/*
 * Decompiled with CFR 0.152.
 */
package com.buck.common.codec;

import com.buck.common.codec.Codec;
import com.buck.common.codec.CodecDecoder;
import com.buck.common.codec.CodecEncoder;
import com.buck.common.codec.MalformedInputException;
import com.buck.common.codec.StandardCodecs;
import com.buck.commons.i18n.ResourceBundle;
import java.io.ByteArrayOutputStream;
import java.util.BitSet;

public class QuotedPrintable
extends Codec {
    private static final BitSet PRINTABLE_CHARS;
    private static final BitSet CRLF_CHARS;
    private static final BitSet HEX_CHARS;
    private static final byte ESCAPE_CHAR = 61;
    private static final byte TAB = 9;
    private static final byte SPACE = 32;
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final int BYTES_PER_LINE = 76;

    public QuotedPrintable() {
        super("quoted-printable", StandardCodecs.aliases_QuotedPrintable);
    }

    @Override
    public CodecDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CodecEncoder newEncoder() {
        return new Encoder(this);
    }

    static {
        int i;
        PRINTABLE_CHARS = new BitSet(256);
        CRLF_CHARS = new BitSet(256);
        HEX_CHARS = new BitSet(256);
        for (i = 33; i <= 60; ++i) {
            PRINTABLE_CHARS.set(i);
        }
        for (i = 62; i <= 126; ++i) {
            PRINTABLE_CHARS.set(i);
        }
        PRINTABLE_CHARS.set(9);
        PRINTABLE_CHARS.set(32);
        CRLF_CHARS.set(13);
        CRLF_CHARS.set(10);
        for (i = 48; i <= 57; ++i) {
            HEX_CHARS.set(i);
        }
        for (i = 65; i <= 70; ++i) {
            HEX_CHARS.set(i);
        }
    }

    private static class Encoder
    extends CodecEncoder {
        public Encoder(Codec codec) {
            super(codec);
        }

        private void encodeQuotedPrintable(int b, ByteArrayOutputStream buffer) {
            buffer.write(61);
            char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
            buffer.write(hex1);
            buffer.write(hex2);
        }

        private void emitCRLF(ByteArrayOutputStream buffer) {
            buffer.write(13);
            buffer.write(10);
        }

        @Override
        public byte[] encode(byte[] bytes) {
            if (bytes == null) {
                return null;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] SOFT_LINE_BREAK = new byte[]{61, 13, 10};
            int count = 0;
            boolean inCRLF = false;
            for (int i = 0; i < bytes.length; ++i) {
                int b = bytes[i];
                if (b < 0) {
                    b = 256 + b;
                }
                if (b == 13) {
                    inCRLF = true;
                    this.emitCRLF(buffer);
                    continue;
                }
                if (b == 10) {
                    if (!inCRLF) {
                        this.emitCRLF(buffer);
                    }
                } else if (PRINTABLE_CHARS.get(b)) {
                    if (++count > 75) {
                        buffer.write(SOFT_LINE_BREAK, 0, SOFT_LINE_BREAK.length);
                        count = 1;
                    }
                    buffer.write(b);
                } else {
                    if ((count += 3) > 75) {
                        buffer.write(SOFT_LINE_BREAK, 0, SOFT_LINE_BREAK.length);
                        count = 3;
                    }
                    this.encodeQuotedPrintable(b, buffer);
                }
                inCRLF = false;
            }
            return buffer.toByteArray();
        }
    }

    private static class Decoder
    extends CodecDecoder {
        public Decoder(Codec codec) {
            super(codec);
        }

        @Override
        public byte[] decode(byte[] encoded) {
            if (encoded == null) {
                return null;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            for (int i = 0; i < encoded.length; ++i) {
                byte b = encoded[i];
                if (PRINTABLE_CHARS.get(b) || CRLF_CHARS.get(b)) {
                    buffer.write(b);
                    continue;
                }
                if (b == 61) {
                    if (++i < encoded.length) {
                        byte b1 = encoded[i];
                        if (HEX_CHARS.get(b1)) {
                            int u = Character.digit((char)b1, 16);
                            if (++i < encoded.length) {
                                byte b2 = encoded[i];
                                if (HEX_CHARS.get(b2)) {
                                    int l = Character.digit((char)encoded[i], 16);
                                    buffer.write((char)((u << 4) + l));
                                    continue;
                                }
                                Object[] arguments = new Object[]{"quoted-printable"};
                                String message = ResourceBundle.formatResourceBundleMessage(QuotedPrintable.class, (String)"CODEC_DECODER_MALFORMED_INPUT", (Object[])arguments);
                                throw new MalformedInputException(message);
                            }
                            Object[] arguments = new Object[]{"quoted-printable"};
                            String message = ResourceBundle.formatResourceBundleMessage(QuotedPrintable.class, (String)"CODEC_DECODER_MALFORMED_INPUT", (Object[])arguments);
                            throw new MalformedInputException(message);
                        }
                        while (b1 != 13) {
                            if (b1 != 32 && b1 != 9) {
                                Object[] arguments = new Object[]{"quoted-printable"};
                                String message = ResourceBundle.formatResourceBundleMessage(QuotedPrintable.class, (String)"CODEC_DECODER_MALFORMED_INPUT", (Object[])arguments);
                                throw new MalformedInputException(message);
                            }
                            b1 = encoded[++i];
                        }
                        b1 = encoded[++i];
                        assert (b1 == 10);
                        continue;
                    }
                    Object[] arguments = new Object[]{"quoted-printable"};
                    String message = ResourceBundle.formatResourceBundleMessage(QuotedPrintable.class, (String)"CODEC_DECODER_MALFORMED_INPUT", (Object[])arguments);
                    throw new MalformedInputException(message);
                }
                Object[] arguments = new Object[]{"quoted-printable"};
                String message = ResourceBundle.formatResourceBundleMessage(QuotedPrintable.class, (String)"CODEC_DECODER_MALFORMED_INPUT", (Object[])arguments);
                throw new MalformedInputException(message);
            }
            return buffer.toByteArray();
        }
    }
}

