/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesprint.rx;

import io.reactivesprint.Preconditions;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;

final class TransformerForwardWhileTrue<T>
implements Observable.Transformer<T, T> {
    private final Observable<Boolean> shouldForwardObservable;
    private Subscription observableSubscription;

    public TransformerForwardWhileTrue(Observable<Boolean> shouldForwardObservable) {
        Preconditions.checkNotNull(shouldForwardObservable, "shouldForwardObservable");
        this.shouldForwardObservable = shouldForwardObservable;
    }

    public Observable<T> call(final Observable<T> observable) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<T>(){

            public void call(final Subscriber<? super T> subscriber) {
                Subscription forwardSubscription = TransformerForwardWhileTrue.this.shouldForwardObservable.subscribe((Subscriber)new Subscriber<Boolean>(){

                    public void onCompleted() {
                        subscriber.onCompleted();
                    }

                    public void onError(Throwable e) {
                        subscriber.onError(e);
                    }

                    public void onNext(Boolean forward) {
                        if (forward.booleanValue()) {
                            TransformerForwardWhileTrue.this.observableSubscription = observable.subscribe(new Subscriber<T>(){

                                public void onCompleted() {
                                }

                                public void onError(Throwable e) {
                                    subscriber.onError(e);
                                }

                                public void onNext(T t) {
                                    subscriber.onNext(t);
                                }
                            });
                            subscriber.add(TransformerForwardWhileTrue.this.observableSubscription);
                        } else if (TransformerForwardWhileTrue.this.observableSubscription != null) {
                            TransformerForwardWhileTrue.this.observableSubscription.unsubscribe();
                        }
                    }
                });
                subscriber.add(forwardSubscription);
            }
        });
    }
}

