/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.DoublePredicate;

@FunctionalInterface
public interface DoubleSQLPredicate {
    public boolean test(double var1) throws SQLException;

    default public DoubleSQLPredicate and(DoubleSQLPredicate other) {
        Objects.requireNonNull(other);
        return value -> this.test(value) && other.test(value);
    }

    default public DoubleSQLPredicate negate() {
        return value -> !this.test(value);
    }

    default public DoubleSQLPredicate or(DoubleSQLPredicate other) {
        Objects.requireNonNull(other);
        return value -> this.test(value) || other.test(value);
    }

    public static DoublePredicate unchecked(DoubleSQLPredicate predicate) {
        Objects.requireNonNull(predicate);
        return value -> {
            try {
                return predicate.test(value);
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static DoubleSQLPredicate checked(DoublePredicate predicate) {
        Objects.requireNonNull(predicate);
        return value -> {
            try {
                return predicate.test(value);
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

