/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.IntToDoubleFunction;

@FunctionalInterface
public interface IntToDoubleSQLFunction {
    public double applyAsDouble(int var1) throws SQLException;

    public static IntToDoubleFunction unchecked(IntToDoubleSQLFunction function) {
        Objects.requireNonNull(function);
        return value -> {
            try {
                return function.applyAsDouble(value);
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static IntToDoubleSQLFunction checked(IntToDoubleFunction function) {
        Objects.requireNonNull(function);
        return value -> {
            try {
                return function.applyAsDouble(value);
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

