/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.IntToLongFunction;

@FunctionalInterface
public interface IntToLongSQLFunction {
    public long applyAsLong(int var1) throws SQLException;

    public static IntToLongFunction unchecked(IntToLongSQLFunction function) {
        Objects.requireNonNull(function);
        return value -> {
            try {
                return function.applyAsLong(value);
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static IntToLongSQLFunction checked(IntToLongFunction function) {
        Objects.requireNonNull(function);
        return value -> {
            try {
                return function.applyAsLong(value);
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

