/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.IntUnaryOperator;

@FunctionalInterface
public interface IntUnarySQLOperator {
    public int applyAsInt(int var1) throws SQLException;

    default public IntUnarySQLOperator compose(IntUnarySQLOperator before) {
        Objects.requireNonNull(before);
        return operand -> this.applyAsInt(before.applyAsInt(operand));
    }

    default public IntUnarySQLOperator andThen(IntUnarySQLOperator after) {
        Objects.requireNonNull(after);
        return operand -> after.applyAsInt(this.applyAsInt(operand));
    }

    public static IntUnarySQLOperator identity() {
        return operand -> operand;
    }

    public static IntUnaryOperator unchecked(IntUnarySQLOperator operator) {
        Objects.requireNonNull(operator);
        return operand -> {
            try {
                return operator.applyAsInt(operand);
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static IntUnarySQLOperator checked(IntUnaryOperator operator) {
        Objects.requireNonNull(operator);
        return operand -> {
            try {
                return operator.applyAsInt(operand);
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

