/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.LongBinaryOperator;

@FunctionalInterface
public interface LongBinarySQLOperator {
    public long applyAsLong(long var1, long var3) throws SQLException;

    public static LongBinaryOperator unchecked(LongBinarySQLOperator operator) {
        Objects.requireNonNull(operator);
        return (left, right) -> {
            try {
                return operator.applyAsLong(left, right);
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static LongBinarySQLOperator checked(LongBinaryOperator operator) {
        Objects.requireNonNull(operator);
        return (left, right) -> {
            try {
                return operator.applyAsLong(left, right);
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

