/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.ObjLongConsumer;

@FunctionalInterface
public interface ObjLongSQLConsumer<T> {
    public void accept(T var1, long var2) throws SQLException;

    public static <T> ObjLongConsumer<T> unchecked(ObjLongSQLConsumer<? super T> operation) {
        Objects.requireNonNull(operation);
        return (t, value) -> {
            try {
                operation.accept(t, value);
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static <T> ObjLongSQLConsumer<T> checked(ObjLongConsumer<? super T> operation) {
        Objects.requireNonNull(operation);
        return (t, value) -> {
            try {
                operation.accept(t, value);
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

