/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.ToDoubleBiFunction;

@FunctionalInterface
public interface ToDoubleSQLBiFunction<T, U> {
    public double applyAsDouble(T var1, U var2) throws SQLException;

    public static <T, U> ToDoubleBiFunction<T, U> unchecked(ToDoubleSQLBiFunction<? super T, ? super U> function) {
        Objects.requireNonNull(function);
        return (t, u) -> {
            try {
                return function.applyAsDouble(t, u);
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static <T, U> ToDoubleSQLBiFunction<T, U> checked(ToDoubleBiFunction<? super T, ? super U> function) {
        Objects.requireNonNull(function);
        return (t, u) -> {
            try {
                return function.applyAsDouble(t, u);
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

