/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.ToDoubleFunction;

@FunctionalInterface
public interface ToDoubleSQLFunction<T> {
    public double applyAsDouble(T var1) throws SQLException;

    public static <T> ToDoubleFunction<T> unchecked(ToDoubleSQLFunction<? super T> function) {
        Objects.requireNonNull(function);
        return value -> {
            try {
                return function.applyAsDouble(value);
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static <T> ToDoubleSQLFunction<T> checked(ToDoubleFunction<? super T> function) {
        Objects.requireNonNull(function);
        return value -> {
            try {
                return function.applyAsDouble(value);
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

