/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.ToLongFunction;

@FunctionalInterface
public interface ToLongSQLFunction<T> {
    public long applyAsLong(T var1) throws SQLException;

    public static <T> ToLongFunction<T> unchecked(ToLongSQLFunction<? super T> function) {
        Objects.requireNonNull(function);
        return value -> {
            try {
                return function.applyAsLong(value);
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static <T> ToLongSQLFunction<T> checked(ToLongFunction<? super T> function) {
        Objects.requireNonNull(function);
        return value -> {
            try {
                return function.applyAsLong(value);
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

