/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.BooleanSupplier;

@FunctionalInterface
public interface BooleanSQLSupplier {
    public boolean getAsBoolean() throws SQLException;

    public static BooleanSupplier unchecked(BooleanSQLSupplier supplier) {
        Objects.requireNonNull(supplier);
        return () -> {
            try {
                return supplier.getAsBoolean();
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static BooleanSQLSupplier checked(BooleanSupplier supplier) {
        Objects.requireNonNull(supplier);
        return () -> {
            try {
                return supplier.getAsBoolean();
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

