/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.DoubleFunction;

@FunctionalInterface
public interface DoubleSQLFunction<R> {
    public R apply(double var1) throws SQLException;

    public static <R> DoubleFunction<R> unchecked(DoubleSQLFunction<? extends R> function) {
        Objects.requireNonNull(function);
        return value -> {
            try {
                return function.apply(value);
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static <R> DoubleSQLFunction<R> checked(DoubleFunction<? extends R> function) {
        Objects.requireNonNull(function);
        return value -> {
            try {
                return function.apply(value);
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

