/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.LongUnaryOperator;

@FunctionalInterface
public interface LongUnarySQLOperator {
    public long applyAsLong(long var1) throws SQLException;

    default public LongUnarySQLOperator compose(LongUnarySQLOperator before) {
        Objects.requireNonNull(before);
        return operand -> this.applyAsLong(before.applyAsLong(operand));
    }

    default public LongUnarySQLOperator andThen(LongUnarySQLOperator after) {
        Objects.requireNonNull(after);
        return operand -> after.applyAsLong(this.applyAsLong(operand));
    }

    public static LongUnarySQLOperator identity() {
        return operand -> operand;
    }

    public static LongUnaryOperator unchecked(LongUnarySQLOperator operator) {
        Objects.requireNonNull(operator);
        return operand -> {
            try {
                return operator.applyAsLong(operand);
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static LongUnarySQLOperator checked(LongUnaryOperator operator) {
        Objects.requireNonNull(operator);
        return operand -> {
            try {
                return operator.applyAsLong(operand);
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

