/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.BiConsumer;

@FunctionalInterface
public interface SQLBiConsumer<T, U> {
    public void accept(T var1, U var2) throws SQLException;

    default public SQLBiConsumer<T, U> andThen(SQLBiConsumer<? super T, ? super U> after) {
        Objects.requireNonNull(after);
        return (t, u) -> {
            this.accept(t, u);
            after.accept(t, u);
        };
    }

    public static <T, U> BiConsumer<T, U> unchecked(SQLBiConsumer<? super T, ? super U> operation) {
        Objects.requireNonNull(operation);
        return (t, u) -> {
            try {
                operation.accept(t, u);
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static <T, U> SQLBiConsumer<T, U> checked(BiConsumer<? super T, ? super U> operation) {
        Objects.requireNonNull(operation);
        return (t, u) -> {
            try {
                operation.accept(t, u);
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

