/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.SQLFunction;
import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.UnaryOperator;

@FunctionalInterface
public interface UnarySQLOperator<T>
extends SQLFunction<T, T> {
    public static <T> UnarySQLOperator<T> identity() {
        return t -> t;
    }

    public static <T> UnaryOperator<T> unchecked(UnarySQLOperator<T> operator) {
        Objects.requireNonNull(operator);
        return t -> {
            try {
                return operator.apply(t);
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static <T> UnarySQLOperator<T> checked(UnaryOperator<T> operator) {
        Objects.requireNonNull(operator);
        return t -> {
            try {
                return operator.apply(t);
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

