/*
 * Decompiled with CFR 0.152.
 */
package org.basicmon.atomic;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.basicmon.BasicTimer;
import org.basicmon.BasicTimerSplit;
import org.basicmon.BasicTimerStats;
import org.basicmon.atomic.BasicMonAtomicBase;
import org.basicmon.util.BasicMonUtil;
import org.basicmon.util.BasicTimerUtil;

public final class BasicTimerAtomicImpl<V>
extends BasicMonAtomicBase
implements BasicTimer<V> {
    private final AtomicInteger active = new AtomicInteger(0);
    private final AtomicLong activeTotal = new AtomicLong(0L);
    private final AtomicLong activeCounter = new AtomicLong(0L);
    private BasicTimerStats basicTimerStats;

    public BasicTimerAtomicImpl(String id) {
        super(id, false);
    }

    public BasicTimerAtomicImpl(String id, boolean withStats) {
        super(id, withStats);
        if (withStats) {
            try {
                this.basicTimerStats = new BasicTimerStats();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void reset() {
        this.active.set(0);
        this.activeTotal.set(0L);
        this.activeCounter.set(0L);
        super.reset();
    }

    @Override
    public BasicTimerSplit start() {
        int currentActive = this.active.incrementAndGet();
        this.activeTotal.addAndGet(currentActive);
        this.activeCounter.incrementAndGet();
        if (this.withStats) {
            this.basicTimerStats.updateActiveStats(currentActive);
        }
        return new BasicTimerSplit(this, System.nanoTime());
    }

    @Override
    public long stop(BasicTimerSplit split) {
        long splitTime = System.nanoTime() - split.getStartTime();
        this.active.decrementAndGet();
        super.setVal(splitTime);
        return splitTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V doInTimer(Callable<V> function) throws Exception {
        BasicTimerSplit split = this.start();
        try {
            V v = function.call();
            return v;
        }
        finally {
            split.stop();
        }
    }

    @Override
    public void addTime(long time) {
        super.setVal(time);
    }

    @Override
    public int getActive() {
        return this.active.get();
    }

    @Override
    public double getActiveMean() {
        return (double)this.activeTotal.get() / (double)this.activeCounter.get();
    }

    @Override
    public long getActiveMax() {
        return this.withStats ? this.basicTimerStats.getActiveMax() : -1L;
    }

    @Override
    public double getActiveVariance() {
        return this.withStats ? this.basicTimerStats.getActiveVariance() : -1.0;
    }

    @Override
    public double getActiveStdDev() {
        if (!this.withStats) {
            return -1.0;
        }
        double variance = this.getActiveVariance();
        long counter = this.getVal();
        return BasicMonUtil.calcStdDev(variance, counter);
    }

    public String toString() {
        return BasicTimerUtil.toString(this);
    }
}

