/*
 * Decompiled with CFR 0.152.
 */
package com.rodbate.httpserver.dispatcher;

import com.rodbate.httpserver.common.RequestMappers;
import com.rodbate.httpserver.common.RequestMeta;
import com.rodbate.httpserver.common.ServerConfig;
import com.rodbate.httpserver.common.ServerConstants;
import com.rodbate.httpserver.common.StringUtil;
import com.rodbate.httpserver.dispatcher.BaseRequestDispatcher;
import com.rodbate.httpserver.http.FileHandler;
import com.rodbate.httpserver.http.RBHttpRequest;
import com.rodbate.httpserver.http.RBHttpResponse;
import com.rodbate.httpserver.http.RequestMethod;
import com.rodbate.httpserver.upload.DiskFileItemFactory;
import com.rodbate.httpserver.upload.FileItem;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRequestDispatcher
extends BaseRequestDispatcher {
    private HttpPostRequestDecoder decoder;
    private static final int SIZE_THRESHOLD = 10240;
    private static final long File_EXIST_DURATION = 10L;
    private static final DiskFileItemFactory factory = new DiskFileItemFactory(10240, null, 10L);
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRequestDispatcher.class);
    private RBHttpRequest request;
    private RequestMeta meta;

    @Override
    protected void dispatch(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        if (msg instanceof RBHttpRequest) {
            this.request = (RBHttpRequest)msg;
            String uri = this.request.uri();
            if ("/favicon.ico".equals(uri = URLDecoder.decode(uri, "UTF-8"))) {
                InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/ico/httpserver.ico");
                byte[] bytes = new byte[is.available()];
                is.read(bytes);
                is.close();
                ByteBuf response = Unpooled.copiedBuffer((byte[])bytes);
                RBHttpResponse resp = new RBHttpResponse(this.request.protocolVersion(), HttpResponseStatus.OK);
                resp.setHeader("Content-Type", "image/x-icon");
                resp.setHeader("Content-Length", bytes.length);
                ctx.channel().write((Object)resp);
                ctx.channel().writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            } else if ("/".equals(uri) || "".equals(uri)) {
                this.handlePageResponse(ctx, this.request, "/html/welcome.html", HttpResponseStatus.OK);
            } else {
                HttpMethod method = this.request.method();
                if (method == HttpMethod.GET) {
                    String downloadPath = ServerConfig.getProperty("downloadPath");
                    if (StringUtil.isNull(downloadPath)) {
                        downloadPath = ServerConstants.DEFAULT_DOWNLOAD_PATH;
                    }
                    if (downloadPath.endsWith(File.separator)) {
                        downloadPath = downloadPath.substring(0, downloadPath.lastIndexOf(File.separator));
                    }
                    String fileName = uri.replace("/", File.separator);
                    downloadPath = downloadPath + fileName;
                    LOG.info("===== ==============  download file path : " + downloadPath);
                    boolean download = FileHandler.download(ctx, this.request, downloadPath);
                    if (download) {
                        return;
                    }
                }
                uri = this.parseUrl(uri, this.request);
                this.meta = RequestMappers.getMeta(uri);
                if (this.meta == null) {
                    this.handlePageResponse(ctx, this.request, "/html/notFound.html", HttpResponseStatus.NOT_FOUND);
                } else {
                    List<RequestMethod> requestMethod = this.meta.getRequestMethod();
                    boolean methodAllow = false;
                    if (requestMethod.size() == 1 && requestMethod.get(0).getDesc().equals("ALL")) {
                        methodAllow = true;
                    } else {
                        for (RequestMethod rm : requestMethod) {
                            if (!method.name().equals(rm.getDesc())) continue;
                            methodAllow = true;
                            break;
                        }
                    }
                    if (methodAllow) {
                        if (this.request.method() == HttpMethod.POST || this.request.method() == HttpMethod.PUT) {
                            boolean readingChunk = HttpUtil.isTransferEncodingChunked((HttpMessage)this.request);
                            LOG.info("=========== request chunk is {}  =======", (Object)readingChunk);
                        }
                        if (this.request.method() == HttpMethod.GET) {
                            this.dispatch0(ctx);
                        }
                    } else {
                        this.handlePageResponse(ctx, this.request, "/html/methodNotAllowed.html", HttpResponseStatus.METHOD_NOT_ALLOWED);
                    }
                }
            }
        }
        if (this.request.method() != HttpMethod.GET && msg instanceof HttpContent) {
            try {
                this.handlePostBody(msg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (msg instanceof LastHttpContent) {
            LOG.info(" =========== last http content : " + ((LastHttpContent)msg).content().toString());
            this.dispatch0(ctx);
        }
    }

    public void handlePostBody(HttpObject msg) throws UnsupportedEncodingException {
        String[] kv;
        String[] split;
        HttpContent content = (HttpContent)msg;
        ByteBuf byteBuf = content.content();
        String rs = byteBuf.toString(Charset.forName("ISO8859-1"));
        String requestContentType = this.request.getHeaderByName("Content-Type");
        if ("application/x-www-form-urlencoded".equals(requestContentType) && rs.contains("&")) {
            for (String s : split = rs.split("&")) {
                if (!s.contains("=")) continue;
                kv = s.split("=");
                this.request.setParameter(kv[0], kv[1]);
            }
        }
        if (StringUtil.isNotNull(requestContentType) && requestContentType.startsWith("multipart/form-data")) {
            FileItem fileItem = this.request.getFileItem();
            if (fileItem == null) {
                fileItem = factory.createItem(null, null, "upload", false);
            }
            try {
                OutputStream outputStream = fileItem.getOutputStream();
                outputStream.write(rs.getBytes("ISO8859-1"));
                this.request.setFileItem(fileItem);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (StringUtil.isNotNull(requestContentType) && requestContentType.startsWith("text/plain") && rs.contains("&")) {
            for (String s : split = rs.split("&")) {
                if (!s.contains("=")) continue;
                kv = s.split("=");
                this.request.setParameter(kv[0], kv[1]);
            }
        }
        if (StringUtil.isNotNull(requestContentType) && requestContentType.startsWith("application/json")) {
            this.request.setJsonString(rs);
        }
    }

    private String getFilenameIfAbsent(String contentDisposition) {
        Objects.requireNonNull(contentDisposition);
        String filename = null;
        if (contentDisposition.contains("filename")) {
            filename = contentDisposition.split("=")[2].replace("\"", "");
        }
        return filename;
    }

    private void dispatch0(ChannelHandlerContext ctx) throws InstantiationException, IllegalAccessException {
        RBHttpResponse response = new RBHttpResponse(this.request.protocolVersion(), HttpResponseStatus.OK);
        Class target = this.meta.getTarget();
        Method m = this.meta.getMethod();
        response.setHeader("Content-Type", this.meta.getResponseContentType());
        Object resp = this.invokeMethod(target, m, this.request, response);
        if (HttpUtil.isKeepAlive((HttpMessage)this.request)) {
            response.setHeader("Connection", "keep-alive");
        }
        if ("application/octet-stream".equalsIgnoreCase(response.headers().get("Content-Type"))) {
            if (resp instanceof InputStream) {
                InputStream is = (InputStream)resp;
                byte[] b = new byte[4096];
                try {
                    int len;
                    response.setHeader("Content-Length", is.available());
                    ctx.channel().write((Object)response);
                    while ((len = is.read(b)) > 0) {
                        ByteBuf buffer = Unpooled.copiedBuffer((byte[])new String(b, 0, len, "ISO8859-1").getBytes("ISO8859-1"));
                        ctx.channel().write((Object)buffer);
                    }
                    ctx.channel().writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (resp instanceof String) {
                String str = (String)resp;
                try {
                    ByteBuf buffer = Unpooled.copiedBuffer((byte[])str.getBytes("ISO8859-1"));
                    response.setHeader("Content-Length", buffer.readableBytes());
                    ctx.channel().write((Object)response);
                    ctx.channel().writeAndFlush((Object)buffer).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(resp);
            ByteBuf buffer = Unpooled.copiedBuffer((byte[])sb.toString().getBytes());
            response.setContentTypeIfAbsent();
            response.setHeader("Content-Length", buffer.readableBytes());
            ctx.channel().write((Object)response);
            ctx.channel().writeAndFlush((Object)buffer).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void handlePageResponse(ChannelHandlerContext ctx, RBHttpRequest request, String pagePath, HttpResponseStatus status) throws IOException {
        String line;
        StringBuilder sb = new StringBuilder();
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(pagePath);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        ByteBuf content = Unpooled.copiedBuffer((byte[])sb.toString().getBytes());
        RBHttpResponse resp = new RBHttpResponse(request.protocolVersion(), status);
        resp.setHeader("Content-Type", "text/html");
        resp.setHeader("Content-Length", content.readableBytes());
        ctx.channel().write((Object)resp);
        ctx.channel().writeAndFlush((Object)content).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeMethod(Class target, Method method, RBHttpRequest request, RBHttpResponse response) throws IllegalAccessException, InstantiationException {
        Object resp = null;
        Object instance = target.newInstance();
        boolean accessible = method.isAccessible();
        try {
            method.setAccessible(true);
            resp = method.invoke(instance, new Object[]{request, response});
        }
        catch (Exception e) {
            try {
                if (e instanceof IllegalArgumentException) {
                    resp = method.invoke(instance, new Object[]{request});
                }
            }
            catch (Exception e1) {
                try {
                    if (e1 instanceof IllegalArgumentException) {
                        resp = method.invoke(instance, new Object[]{response});
                    }
                }
                catch (Exception e2) {
                    try {
                        if (e2 instanceof IllegalArgumentException) {
                            resp = method.invoke(instance, new Object[0]);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        finally {
            method.setAccessible(accessible);
        }
        return resp;
    }

    private String parseUrl(String uri, RBHttpRequest request) {
        String url = uri;
        if (uri.contains("?")) {
            String[] split;
            url = uri.substring(0, uri.indexOf("?"));
            String paramStr = uri.substring(uri.indexOf("?") + 1);
            for (String str : split = paramStr.split("&")) {
                if (!str.contains("=")) continue;
                String key = str.substring(0, str.indexOf("="));
                String value = str.substring(str.indexOf("=") + 1);
                request.setParameter(key, value);
            }
        }
        return url;
    }
}

