/*
 * Decompiled with CFR 0.152.
 */
package com.rodbate.httpserver.http;

import com.rodbate.httpserver.common.StringUtil;
import com.rodbate.httpserver.upload.FileItem;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RBHttpRequest
extends DefaultHttpRequest {
    private FileItem fileItem;
    private static final HttpDataFactory FACTORY = new DefaultHttpDataFactory(16384L);
    private HttpPostRequestDecoder httpPostRequestDecoder;
    private Map<String, Object> params = new HashMap<String, Object>();
    private String jsonString;

    public RBHttpRequest(HttpVersion httpVersion, HttpMethod method, String uri) {
        super(httpVersion, method, uri);
    }

    public RBHttpRequest(HttpVersion httpVersion, HttpMethod method, String uri, boolean validateHeaders) {
        super(httpVersion, method, uri, validateHeaders);
    }

    public RBHttpRequest(HttpVersion httpVersion, HttpMethod method, String uri, HttpHeaders headers) {
        super(httpVersion, method, uri, headers);
    }

    public String getJsonString() {
        return this.jsonString;
    }

    public void setJsonString(String jsonString) {
        this.jsonString = jsonString;
    }

    public void setParameter(String key, Object value) {
        this.params.put(key, value);
    }

    public Object getParameter(String key) {
        return this.params.get(key);
    }

    public HttpPostRequestDecoder initParametersByPost() {
        HttpMethod method = this.method();
        if (method == HttpMethod.POST || method == HttpMethod.PUT) {
            if (this.httpPostRequestDecoder == null) {
                this.httpPostRequestDecoder = new HttpPostRequestDecoder(FACTORY, (HttpRequest)this, Charset.forName("UTF-8"));
            }
            try {
                List bodyHttpDatas = this.httpPostRequestDecoder.getBodyHttpDatas();
                for (InterfaceHttpData bodyData : bodyHttpDatas) {
                    if (!(bodyData instanceof Attribute)) continue;
                    Attribute attr = (Attribute)bodyData;
                    String name = attr.getName();
                    try {
                        String value = attr.getValue();
                        this.params.put(name, value);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.httpPostRequestDecoder;
    }

    public String getHeaderByName(String name) {
        return this.headers().get(name);
    }

    public Set<Cookie> getCookie() {
        String value = this.headers().get("Cookie");
        Set cookies = StringUtil.isNull(value) ? Collections.emptySet() : ServerCookieDecoder.STRICT.decode(value);
        return cookies;
    }

    public FileItem getFileItem() {
        return this.fileItem;
    }

    public void setFileItem(FileItem fileItem) {
        this.fileItem = fileItem;
    }
}

