/*
 * Decompiled with CFR 0.152.
 */
package com.rodbate.httpserver.common;

import com.alibaba.fastjson.JSON;
import com.rodbate.httpserver.annotations.RequestMapping;
import com.rodbate.httpserver.common.ClassReflection;
import com.rodbate.httpserver.common.RequestMeta;
import com.rodbate.httpserver.http.RequestMethod;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestMappers {
    public static final Map<String, RequestMeta> urlMappers = new HashMap<String, RequestMeta>();
    private static final Logger LOG = LoggerFactory.getLogger(RequestMappers.class);

    public static void init() {
        LOG.info("========>>>>>>>> URL Mapper Initialize Begin");
        RequestMappers.initMappers();
        RequestMappers.printMappers();
        LOG.info("========>>>>>>>> URL Mapper Initialize Finish");
    }

    public static RequestMeta getMeta(String uri) {
        return urlMappers.get(uri);
    }

    private static void printMappers() {
        ArrayList<PrintUrl> printUrls = new ArrayList<PrintUrl>();
        for (Map.Entry<String, RequestMeta> entry : urlMappers.entrySet()) {
            RequestMeta value = entry.getValue();
            ArrayList<String> list = new ArrayList<String>();
            for (RequestMethod m : value.getRequestMethod()) {
                list.add(m.getDesc());
            }
            if (list.size() == 0) {
                list.add("ALL");
            }
            PrintUrl print = new PrintUrl(entry.getKey(), value.getTarget().getName() + "." + value.getMethod().getName(), list, value.getResponseContentType());
            printUrls.add(print);
        }
        LOG.info(JSON.toJSONString(printUrls));
    }

    private static void initMappers() {
        HashMap urlClass = new HashMap();
        HashMap urlMethod = new HashMap();
        Set<Class<?>> classes = ClassReflection.getClassesByAnnotation(RequestMapping.class);
        for (Class<?> c : classes) {
            RequestMapping rm = c.getDeclaredAnnotation(RequestMapping.class);
            urlClass.put(c, rm.value());
        }
        Set<Method> methods = ClassReflection.getMethodsByAnnotation(RequestMapping.class);
        for (Method m : methods) {
            RequestMapping rm = m.getDeclaredAnnotation(RequestMapping.class);
            String methodUrl = rm.value();
            if (!methodUrl.startsWith("/")) {
                methodUrl = "/" + methodUrl;
            }
            String url = methodUrl;
            Class<?> clazz = m.getDeclaringClass();
            String prefixUrl = (String)urlClass.get(clazz);
            if (prefixUrl != null) {
                if (prefixUrl.endsWith("/")) {
                    prefixUrl = prefixUrl.substring(0, prefixUrl.length());
                }
                url = prefixUrl + methodUrl;
            }
            RequestMeta meta = new RequestMeta();
            meta.setUrl(url);
            meta.setMethod(m);
            ArrayList<RequestMethod> requestMethods = new ArrayList<RequestMethod>();
            requestMethods.addAll(Arrays.asList(rm.method()));
            meta.setRequestMethod(requestMethods);
            meta.setResponseContentType(rm.responseContentType());
            meta.setTarget(clazz);
            urlMappers.put(url, meta);
        }
    }

    private static class PrintUrl {
        String url;
        String method;
        List<String> requestMethod;
        String response;

        public PrintUrl() {
        }

        public PrintUrl(String url, String method, List<String> requestMethod, String response) {
            this.url = url;
            this.method = method;
            this.requestMethod = requestMethod;
            this.response = response;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public List<String> getRequestMethod() {
            return this.requestMethod;
        }

        public void setRequestMethod(List<String> requestMethod) {
            this.requestMethod = requestMethod;
        }

        public String getResponse() {
            return this.response;
        }

        public void setResponse(String response) {
            this.response = response;
        }
    }
}

