/*
 * Decompiled with CFR 0.152.
 */
package com.github.roycetech.commons;

public class ArrayUtils {
    private ArrayUtils() {
    }

    public static Object[][] product(Object[][] arrays) {
        if (arrays == null) {
            return arrays;
        }
        if (arrays.length == 1) {
            return arrays;
        }
        int total = ArrayUtils.computeTotal(arrays);
        int typeCount = arrays.length;
        Object[][] result = new Object[total][typeCount];
        for (int y = 0; y < total; ++y) {
            result[y] = ArrayUtils.computeScenario(y, typeCount, arrays);
        }
        return result;
    }

    private static Object[] computeScenario(int y, int typeCount, Object[][] arrays) {
        Object[] retval = new Object[typeCount];
        for (int x = 0; x < typeCount; ++x) {
            int divisor = ArrayUtils.getDivisor(arrays, x);
            int sourceX = x == arrays.length - 1 ? y % arrays[x].length : y / divisor;
            int sourceY = x;
            retval[x] = arrays[sourceY][sourceX % arrays[x].length];
        }
        return retval;
    }

    private static int computeTotal(Object[][] arrays) {
        int total = arrays[0].length;
        for (int i = 1; i < arrays.length; ++i) {
            total *= arrays[i].length;
        }
        return total;
    }

    private static int getDivisor(Object[][] arrays, int x) {
        int divisor = 1;
        for (int i = x + 1; i < arrays.length; ++i) {
            divisor *= arrays[i].length;
        }
        return divisor;
    }
}

