/*
 * Decompiled with CFR 0.152.
 */
package com.github.ruediste.c3java.invocationRecording;

import com.google.common.base.MoreObjects;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

public class MethodInvocation<T> {
    private final List<T> arguments;
    private final TypeToken<?> instanceType;
    private final Method method;

    public MethodInvocation(TypeToken<?> instanceType, Method method, List<T> arguments) {
        this.instanceType = instanceType;
        this.method = method;
        this.arguments = new ArrayList<T>(arguments);
    }

    public <X> MethodInvocation<X> withArguments(List<X> arguments) {
        return new MethodInvocation<X>(this.instanceType, this.method, arguments);
    }

    public List<T> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    public <O> boolean isCallToSameMethod(MethodInvocation<O> other, BiPredicate<? super T, ? super O> comparator) {
        if (this.method != other.method) {
            return false;
        }
        if (this.arguments.size() != other.getArguments().size()) {
            return false;
        }
        Iterator<T> it = this.arguments.iterator();
        Iterator<O> oit = other.getArguments().iterator();
        while (it.hasNext() && oit.hasNext()) {
            if (comparator.test(it.next(), oit.next())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("method", (Object)this.method).add("arguments", this.arguments).toString();
    }

    public Method getMethod() {
        return this.method;
    }

    public TypeToken<?> getInstanceType() {
        return this.instanceType;
    }

    public <R> MethodInvocation<R> map(BiFunction<AnnotatedType, ? super T, R> func) {
        ArrayList<R> args = new ArrayList<R>();
        Iterator<AnnotatedType> pit = Arrays.asList(this.getMethod().getAnnotatedParameterTypes()).iterator();
        Iterator<T> ait = this.getArguments().iterator();
        while (pit.hasNext() && ait.hasNext()) {
            args.add(func.apply(pit.next(), (AnnotatedType)ait.next()));
        }
        return this.withArguments(args);
    }
}

