/*
 * Decompiled with CFR 0.152.
 */
package com.github.ruediste.c3java.linearization;

import com.github.ruediste.c3java.linearization.DefaultDirectSuperclassesInspector;
import com.github.ruediste.c3java.linearization.DirectSuperclassesInspector;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class JavaC3 {
    private static Map<LinearizationKey, Iterable<Class<?>>> linearizations = Collections.synchronizedMap(new WeakHashMap());

    private static Iterable<Class<?>> mergeLists(List<Class<?>> partialResult, List<List<Class<?>>> remainingInputs, DirectSuperclassesInspector directParentClassesReader) throws JavaC3Exception {
        Class c;
        if (Iterables.all(remainingInputs, (Predicate)Predicates.equalTo(Collections.emptyList()))) {
            return partialResult;
        }
        Optional nextOption = Optional.absent();
        Iterator iterator = Lists.reverse(partialResult).iterator();
        while (iterator.hasNext() && !(nextOption = Iterables.tryFind(directParentClassesReader.directParentClasses(c = (Class)iterator.next()), JavaC3.isCandidate(remainingInputs))).isPresent()) {
        }
        if (nextOption.isPresent()) {
            ArrayList newRemainingInputs = Lists.newArrayList();
            Class next = (Class)nextOption.get();
            for (List<Class<?>> input : remainingInputs) {
                newRemainingInputs.add(input.indexOf(next) == 0 ? input.subList(1, input.size()) : input);
            }
            return JavaC3.mergeLists(Lists.newArrayList((Iterable)Iterables.concat(partialResult, Collections.singletonList(next))), newRemainingInputs, directParentClassesReader);
        }
        throw new JavaC3Exception(directParentClassesReader, partialResult, remainingInputs);
    }

    private static <X> Predicate<X> isCandidate(final Iterable<List<X>> remainingInputs) {
        return new Predicate<X>(){

            Predicate<List<X>> headIs(final X c) {
                return new Predicate<List<X>>(){

                    public boolean apply(List<X> input) {
                        return !input.isEmpty() && c.equals(input.get(0));
                    }
                };
            }

            Predicate<List<X>> tailContains(final X c) {
                return new Predicate<List<X>>(){

                    public boolean apply(List<X> input) {
                        return input.indexOf(c) > 0;
                    }
                };
            }

            public boolean apply(X c) {
                return Iterables.any((Iterable)remainingInputs, this.headIs(c)) && Iterables.all((Iterable)remainingInputs, (Predicate)Predicates.not(this.tailContains(c)));
            }
        };
    }

    private static Iterable<Class<?>> computeClassLinearization(Class<?> c, final DirectSuperclassesInspector dsc) throws JavaC3Exception {
        List<Class<?>> cDirectSuperclasses = dsc.directParentClasses(c);
        Function cplList = new Function<Class<?>, List<Class<?>>>(){

            public List<Class<?>> apply(Class<?> c) {
                return Lists.newArrayList(JavaC3.allSuperclasses(c, dsc));
            }
        };
        return JavaC3.mergeLists(Collections.singletonList(c), Lists.newArrayList((Iterable)Iterables.concat((Iterable)Lists.transform(cDirectSuperclasses, (Function)cplList), Collections.singletonList(cDirectSuperclasses))), dsc);
    }

    public static Iterable<Class<?>> allSuperclasses(Class<?> c) throws JavaC3Exception {
        return JavaC3.allSuperclasses(c, DefaultDirectSuperclassesInspector.INSTANCE);
    }

    public static Iterable<Class<?>> allSuperclasses(Class<?> c, DirectSuperclassesInspector directParentClassesReader) throws JavaC3Exception {
        LinearizationKey key = new LinearizationKey(directParentClassesReader, c);
        Iterable<Class<?>> linearization = linearizations.get(key);
        if (linearization == null) {
            linearization = JavaC3.computeClassLinearization(c, directParentClassesReader);
            linearizations.put(key, linearization);
        }
        return linearization;
    }

    public static void clearCache() {
        linearizations.clear();
    }

    public static class JavaC3Exception
    extends Error {
        private static final long serialVersionUID = 1L;
        private final Iterable<Class<?>> partialResult;
        private final Iterable<List<Class<?>>> remainingInputs;
        private final DirectSuperclassesInspector dsc;

        protected JavaC3Exception(DirectSuperclassesInspector dsc, Iterable<Class<?>> partialResult, Iterable<List<Class<?>>> remainingInputs) {
            super("inconsistent precedence");
            this.dsc = dsc;
            this.partialResult = partialResult;
            this.remainingInputs = remainingInputs;
        }

        public Iterable<Class<?>> getPartialResult() {
            return this.partialResult;
        }

        public Iterable<List<Class<?>>> getRemainingInputs() {
            return this.remainingInputs;
        }

        @Override
        public String toString() {
            ArrayList superclasses = Lists.newArrayListWithCapacity((int)Iterables.size(this.partialResult));
            for (Class<?> c : this.partialResult) {
                superclasses.add(MessageFormat.format("    {0}: {1}", c, this.dsc.directParentClasses(c)));
            }
            return MessageFormat.format("inconsistent precendence:\nsuperclasses:\n {0}\nremaining:\n   {1}", Joiner.on((String)"\n").join((Object)superclasses, (Object)"\n", new Object[0]), this.remainingInputs);
        }
    }

    private static class LinearizationKey {
        public DirectSuperclassesInspector directParentClassesReader;
        public Class<?> type;

        public LinearizationKey(DirectSuperclassesInspector directParentClassesReader, Class<?> type) {
            this.directParentClassesReader = directParentClassesReader;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            LinearizationKey other = (LinearizationKey)o;
            return this.type.equals(other.type) && this.directParentClassesReader.equals(other.directParentClassesReader);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.type, this.directParentClassesReader});
        }
    }
}

