/*
 * Decompiled with CFR 0.152.
 */
package com.github.ruediste.c3java.properties;

import com.github.ruediste.c3java.properties.PropertyAccessor;
import com.github.ruediste.c3java.properties.PropertyInfo;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Objects;

public class PropertyDeclaration {
    private final String name;
    private final Class<?> declaringType;
    private final Method getter;
    private final Method setter;
    private final Field backingField;
    private final Type propertyType;

    public PropertyDeclaration(String name, Class<?> declaringType) {
        this(name, declaringType, null, null, null, null);
    }

    public PropertyDeclaration(String name, Class<?> declaringType, Type propertyType, Method getter, Method setter, Field backingField) {
        this.name = name;
        this.declaringType = declaringType;
        this.propertyType = propertyType;
        this.getter = getter;
        if (getter != null) {
            getter.setAccessible(true);
        }
        this.setter = setter;
        if (setter != null) {
            setter.setAccessible(true);
        }
        this.backingField = backingField;
        if (backingField != null) {
            backingField.setAccessible(true);
        }
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.name, this.declaringType, this.getter, this.setter, this.backingField});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyDeclaration other = (PropertyDeclaration)obj;
        return com.google.common.base.Objects.equal((Object)this.name, (Object)other.name) && com.google.common.base.Objects.equal(this.declaringType, other.declaringType) && com.google.common.base.Objects.equal((Object)this.getter, (Object)other.getter) && com.google.common.base.Objects.equal((Object)this.setter, (Object)other.setter) && com.google.common.base.Objects.equal((Object)this.backingField, (Object)other.backingField);
    }

    public String toString() {
        return Objects.toString(this.declaringType) + "::" + this.name;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getDeclaringType() {
        return this.declaringType;
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    public Field getBackingField() {
        return this.backingField;
    }

    public PropertyDeclaration withAccessor(PropertyAccessor accessor) {
        if (!this.matchesPropertyType(accessor)) {
            throw new RuntimeException("property type of " + accessor + " does not match property type " + this.propertyType);
        }
        switch (accessor.getType()) {
            case GETTER: {
                return new PropertyDeclaration(this.name, this.declaringType, accessor.getPropertyType(), accessor.getMethod(), this.setter, this.backingField);
            }
            case SETTER: {
                return new PropertyDeclaration(this.name, this.declaringType, accessor.getPropertyType(), this.getter, accessor.getMethod(), this.backingField);
            }
        }
        throw new RuntimeException("should not happen");
    }

    public boolean matchesPropertyType(PropertyAccessor accessor) {
        return this.matchesPropertyType(accessor.getPropertyType());
    }

    public boolean matchesPropertyType(Type type) {
        return this.propertyType == null || this.propertyType.equals(type);
    }

    public PropertyDeclaration withBackingField(Field backingField) {
        Type fieldType = backingField.getGenericType();
        if (this.propertyType != null && !this.propertyType.equals(fieldType)) {
            throw new RuntimeException("field type of " + backingField + " does not match property type " + this.propertyType);
        }
        return new PropertyDeclaration(this.name, this.declaringType, fieldType, this.getter, this.setter, backingField);
    }

    public PropertyInfo toInfo() {
        return new PropertyInfo(this.name, this.propertyType, this.getter, this.setter, this.declaringType);
    }

    public Type getPropertyType() {
        return this.propertyType;
    }

    public Object getValue(Object target) {
        try {
            if (this.getter != null) {
                return this.getter.invoke(target, new Object[0]);
            }
            if (this.backingField != null) {
                return this.backingField.get(target);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException("Property declaration " + this.getDeclaringType() + "." + this.getName() + " is not readable");
    }

    public void setValue(Object target, Object value) {
        try {
            if (this.setter != null) {
                this.setter.invoke(target, value);
                return;
            }
            if (this.backingField != null) {
                this.backingField.set(target, value);
                return;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException("Property declaration " + this.getDeclaringType() + "." + this.getName() + " is not writeable");
    }
}

