/*
 * Decompiled with CFR 0.152.
 */
package com.github.ruediste.c3java.properties;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Objects;

public class PropertyInfo {
    private final String name;
    private final Type propertyType;
    private final Method getter;
    private final Method setter;
    private final Class<?> declaringType;

    public PropertyInfo(String name, Type propertyType, Method getter, Method setter, Class<?> declaringType) {
        this.name = name;
        this.propertyType = propertyType;
        if (getter != null) {
            getter.setAccessible(true);
        }
        this.getter = getter;
        if (setter != null) {
            setter.setAccessible(true);
        }
        this.setter = setter;
        this.declaringType = declaringType;
    }

    public Object getValue(Object target) {
        try {
            return this.getter.invoke(target, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void setValue(Object target, Object value) {
        try {
            this.setter.invoke(target, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isReadable() {
        return this.getter != null;
    }

    public boolean isWriteable() {
        return this.setter != null;
    }

    public String getName() {
        return this.name;
    }

    public Type getPropertyType() {
        return this.propertyType;
    }

    public PropertyInfo withGetter(Method getter) {
        return new PropertyInfo(this.name, this.propertyType, getter, this.setter, this.declaringType);
    }

    public PropertyInfo withSetter(Method setter) {
        return new PropertyInfo(this.name, this.propertyType, this.getter, setter, this.declaringType);
    }

    public PropertyInfo mergedWith(PropertyInfo info) {
        if (!Objects.equals(this.name, info.getName())) {
            throw new RuntimeException("names of to be merged properties does not match");
        }
        if (!Objects.equals(this.propertyType, info.getPropertyType())) {
            throw new RuntimeException("types of to be merged properties does not match");
        }
        PropertyInfo result = this;
        if (this.getter == null && info.getGetter() != null) {
            result = result.withGetter(info.getGetter());
        }
        if (this.setter == null && info.getSetter() != null) {
            result = result.withSetter(info.getSetter());
        }
        if (this.declaringType.isAssignableFrom(info.declaringType)) {
            result = result.withDeclaringType(info.declaringType);
        }
        return result;
    }

    private PropertyInfo withDeclaringType(Class<?> declaringType) {
        return new PropertyInfo(this.name, this.propertyType, this.getter, this.setter, declaringType);
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.propertyType, this.getter, this.setter, this.declaringType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyInfo other = (PropertyInfo)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.propertyType, other.propertyType) && Objects.equals(this.getter, other.getter) && Objects.equals(this.setter, other.setter) && Objects.equals(this.declaringType, other.declaringType);
    }

    public String toString() {
        return "PropertyInfo [name=" + this.name + ", propertyType=" + this.propertyType + ", getter=" + this.getter + ", setter=" + this.setter + "]";
    }

    public Class<?> getDeclaringType() {
        return this.declaringType;
    }
}

