/*
 * Decompiled with CFR 0.152.
 */
package com.github.ruediste.c3java.properties;

import com.github.ruediste.c3java.invocationRecording.MethodInvocation;
import com.github.ruediste.c3java.invocationRecording.MethodInvocationRecorder;
import com.github.ruediste.c3java.linearization.JavaC3;
import com.github.ruediste.c3java.properties.NoPropertyAccessor;
import com.github.ruediste.c3java.properties.PropertyAccessor;
import com.github.ruediste.c3java.properties.PropertyDeclaration;
import com.github.ruediste.c3java.properties.PropertyInfo;
import com.github.ruediste.c3java.properties.PropertyPath;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class PropertyUtil {
    private static Map<Class<?>, Map<String, PropertyInfo>> propertyInfoMapCache = new ConcurrentHashMap();
    private static Map<Class<?>, Map<String, PropertyDeclaration>> propertyIntroductionMapCache = new ConcurrentHashMap();

    private PropertyUtil() {
    }

    public static PropertyAccessor getAccessor(Method method) {
        String name;
        if (Modifier.isPrivate(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || method.isAnnotationPresent(NoPropertyAccessor.class)) {
            return null;
        }
        if (method.getName().startsWith("get") && method.getReturnType() != null) {
            name = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, method.getName().substring("get".length()));
            if (method.getParameterCount() == 0) {
                return new PropertyAccessor(name, PropertyAccessor.AccessorType.GETTER, method, method.getGenericReturnType());
            }
        }
        if (method.getName().startsWith("set")) {
            name = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, method.getName().substring("set".length()));
            if (method.getParameterCount() == 1) {
                return new PropertyAccessor(name, PropertyAccessor.AccessorType.SETTER, method, method.getGenericParameterTypes()[0]);
            }
        }
        return null;
    }

    public static Map<String, PropertyDeclaration> getDeclaredProperties(Class<?> type) {
        HashSet<String> failingProperties = new HashSet<String>();
        Map<String, PropertyDeclaration> result = PropertyUtil.getDeclaredProperties(type, failingProperties);
        failingProperties.forEach(x -> {
            PropertyDeclaration cfr_ignored_0 = (PropertyDeclaration)result.remove(x);
        });
        return result;
    }

    public static Map<String, PropertyDeclaration> getDeclaredProperties(Class<?> type, Set<String> failingProperties) {
        PropertyDeclaration property;
        HashMap<String, PropertyDeclaration> result = new HashMap<String, PropertyDeclaration>();
        for (Method method : type.getDeclaredMethods()) {
            PropertyAccessor accessor = PropertyUtil.getAccessor(method);
            if (accessor == null) continue;
            property = (PropertyDeclaration)result.get(accessor.getName());
            if (property == null) {
                property = new PropertyDeclaration(accessor.getName(), type);
            }
            if (property.matchesPropertyType(accessor)) {
                result.put(accessor.getName(), property.withAccessor(accessor));
                continue;
            }
            failingProperties.add(accessor.getName());
        }
        for (AccessibleObject accessibleObject : type.getDeclaredFields()) {
            String name = ((Field)accessibleObject).getName();
            property = (PropertyDeclaration)result.get(name);
            if (property == null) continue;
            if (property.matchesPropertyType(((Field)accessibleObject).getGenericType())) {
                result.put(name, property.withBackingField((Field)accessibleObject));
                continue;
            }
            failingProperties.add(name);
        }
        return result;
    }

    public static PropertyInfo getPropertyInfo(Class<?> type, String name) {
        return PropertyUtil.tryGetPropertyInfo(type, name).orElseThrow(() -> new RuntimeException("no property named " + name + " found on class " + type));
    }

    public static Optional<PropertyInfo> tryGetPropertyInfo(Class<?> type, String name) {
        return Optional.ofNullable(PropertyUtil.getPropertyInfoMap(type).get(name));
    }

    public static Map<String, PropertyInfo> getPropertyInfoMap(Class<?> type) {
        if (type == null || type == Object.class) {
            return Collections.emptyMap();
        }
        Map<String, PropertyInfo> result = propertyInfoMapCache.get(type);
        if (result == null) {
            result = PropertyUtil.calculatePropertyInfoMap(type);
            propertyInfoMapCache.put(type, result);
        }
        return result;
    }

    private static Map<String, PropertyInfo> calculatePropertyInfoMap(Class<?> type) {
        HashMap<String, PropertyInfo> result = new HashMap<String, PropertyInfo>();
        result.putAll(PropertyUtil.getPropertyInfoMap(type.getSuperclass()));
        for (Class<?> t : type.getInterfaces()) {
            Map<String, PropertyInfo> map = PropertyUtil.getPropertyInfoMap(t);
            for (PropertyInfo info : map.values()) {
                PropertyInfo existingInfo = (PropertyInfo)result.get(info.getName());
                if (existingInfo == null) {
                    result.put(info.getName(), info);
                    continue;
                }
                result.put(info.getName(), existingInfo.mergedWith(info));
            }
        }
        for (PropertyDeclaration decl : PropertyUtil.getDeclaredProperties(type).values()) {
            PropertyInfo existingInfo = (PropertyInfo)result.get(decl.getName());
            if (existingInfo != null) continue;
            result.put(decl.getName(), decl.toInfo());
        }
        return result;
    }

    public static PropertyDeclaration getPropertyIntroduction(Class<?> type, String name) {
        return PropertyUtil.getPropertyIntroductionMap(type).get(name);
    }

    public static Map<String, PropertyDeclaration> getPropertyIntroductionMap(Class<?> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        return propertyIntroductionMapCache.computeIfAbsent(type, PropertyUtil::calculatePropertyIntroductionMap);
    }

    private static Map<String, PropertyDeclaration> calculatePropertyIntroductionMap(Class<?> type) {
        HashMap<String, PropertyDeclaration> result = new HashMap<String, PropertyDeclaration>();
        for (Class cls : Lists.reverse((List)Lists.newArrayList(JavaC3.allSuperclasses(type)))) {
            if (Object.class.equals((Object)cls)) continue;
            for (PropertyDeclaration prop : PropertyUtil.getDeclaredProperties(cls).values()) {
                result.putIfAbsent(prop.getName(), prop);
            }
        }
        return result;
    }

    public static PropertyPath toPath(MethodInvocationRecorder recorder) {
        return PropertyUtil.toPath(recorder.getInvocations());
    }

    public static PropertyPath toPath(List<MethodInvocation<Object>> invocations) {
        PropertyPath result = new PropertyPath();
        for (MethodInvocation<Object> invocation : invocations) {
            result.nodes.add(PropertyUtil.getPathNode(invocation));
        }
        return result;
    }

    public static <T> PropertyPath getPropertyPath(Class<T> type, Consumer<T> pathAccessor) {
        return PropertyUtil.getPropertyPath(TypeToken.of(type), pathAccessor);
    }

    public static <T> PropertyPath getPropertyPath(TypeToken<T> type, Consumer<T> pathAccessor) {
        MethodInvocationRecorder recorder = new MethodInvocationRecorder();
        pathAccessor.accept(recorder.getProxy(type));
        return PropertyUtil.toPath(recorder.getInvocations());
    }

    public static PropertyPath.PropertyPathNode getPathNode(MethodInvocation<Object> invocation) {
        return PropertyUtil.tryGetAccessedProperty(invocation).map(p -> new PropertyPath.PropertyNode((PropertyInfo)p)).orElseGet(() -> new PropertyPath.MethodNode(invocation));
    }

    public static PropertyInfo getAccessedProperty(List<MethodInvocation<Object>> invocations) {
        MethodInvocation<Object> last = invocations.get(invocations.size() - 1);
        return PropertyUtil.getAccessedProperty(last);
    }

    public static Optional<PropertyInfo> tryGetAccessedProperty(MethodInvocation<Object> accessorInvocation) {
        PropertyAccessor accessor = PropertyUtil.getAccessor(accessorInvocation.getMethod());
        if (accessor == null) {
            return Optional.empty();
        }
        return PropertyUtil.tryGetPropertyInfo(accessorInvocation.getInstanceType().getRawType(), accessor.getName());
    }

    public static PropertyInfo getAccessedProperty(MethodInvocation<Object> accessorInvocation) {
        PropertyAccessor accessor = PropertyUtil.getAccessor(accessorInvocation.getMethod());
        if (accessor == null) {
            throw new RuntimeException("method " + accessorInvocation.getMethod() + " is no property accessor");
        }
        PropertyInfo info = PropertyUtil.getPropertyInfo(accessorInvocation.getInstanceType().getRawType(), accessor.getName());
        return info;
    }

    public static void clearCache() {
        propertyInfoMapCache.clear();
        propertyIntroductionMapCache.clear();
    }
}

