/*
 * Decompiled with CFR 0.152.
 */
package com.github.ruediste1.lambdaPegParser.weaving;

import com.github.ruediste1.lambdaPegParser.weaving.InliningAdapter;
import com.github.ruediste1.lambdaPegParser.weaving.MinMaxLineMethodAdapter;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.LocalVariablesSorter;
import org.objectweb.asm.tree.MethodNode;

public class MethodCallInliner
extends GeneratorAdapter {
    private final MethodNode toBeInlined;
    private List<CatchBlock> blocks = new ArrayList<CatchBlock>();
    private boolean inlining;
    private boolean afterInlining;
    private MinMaxLineMethodAdapter minMaxLineMethodAdapter;

    public MethodCallInliner(MethodVisitor mv, MethodNode toBeInlined, MinMaxLineMethodAdapter minMaxLineMethodAdapter) {
        super(327680, mv, toBeInlined.access, toBeInlined.name, toBeInlined.desc);
        this.toBeInlined = toBeInlined;
        this.minMaxLineMethodAdapter = minMaxLineMethodAdapter;
    }

    public void visitLineNumber(int line, Label start) {
        if (!this.inlining) {
            if (!this.afterInlining) {
                int min = this.minMaxLineMethodAdapter.getMinLineNumberOr(1);
                super.visitLineNumber(min > 1 ? min - 1 : 1, start);
            } else {
                int max = this.minMaxLineMethodAdapter.getMaxLineNumberOr(1);
                super.visitLineNumber(max + 1, start);
            }
        } else {
            super.visitLineNumber(line, start);
        }
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (!this.shouldBeInlined(owner, name, desc)) {
            this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
            return;
        }
        Label end = new Label();
        this.inlining = true;
        this.toBeInlined.instructions.resetLabels();
        this.toBeInlined.accept((MethodVisitor)new InliningAdapter((LocalVariablesSorter)this, this.toBeInlined.access, this.toBeInlined.desc, end));
        this.inlining = false;
        this.afterInlining = true;
        super.visitLabel(end);
        Type returnType = Type.getMethodType((String)this.toBeInlined.desc).getReturnType();
        this.valueOf(returnType);
    }

    private boolean shouldBeInlined(String owner, String name, String desc) {
        return "com/github/ruediste1/lambdaPegParser/PrototypeParser".equals(owner) && "sampleRule".equals(name);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        if (!this.inlining) {
            this.blocks.add(new CatchBlock(start, end, handler, type));
        } else {
            super.visitTryCatchBlock(start, end, handler, type);
        }
    }

    public void visitMaxs(int stack, int locals) {
        for (CatchBlock b : this.blocks) {
            super.visitTryCatchBlock(b.start, b.end, b.handler, b.type);
        }
        super.visitMaxs(stack, locals);
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
    }

    public class CatchBlock {
        private Label start;
        private Label handler;
        private String type;
        private Label end;

        public CatchBlock(Label start, Label end, Label handler, String type) {
            this.start = start;
            this.end = end;
            this.handler = handler;
            this.type = type;
        }
    }
}

