/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.model;

import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.model.AbstractRequest;
import com.github.scribejava.core.model.ForceTypeOfHttpRequest;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.ScribeJavaConfig;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuthService;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.ProxyServer;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

public class OAuthRequestAsync
extends AbstractRequest {
    public static final ResponseConverter<Response> RESPONSE_CONVERTER = new ResponseConverter<Response>(){

        @Override
        public Response convert(com.ning.http.client.Response response) throws IOException {
            FluentCaseInsensitiveStringsMap map = response.getHeaders();
            HashMap<String, String> headersMap = new HashMap<String, String>();
            for (Map.Entry header : map) {
                StringBuilder value = new StringBuilder();
                for (String str : (List)header.getValue()) {
                    value.append(str);
                }
                headersMap.put((String)header.getKey(), value.toString());
            }
            return new Response(response.getStatusCode(), response.getStatusText(), headersMap, response.getResponseBody(), response.getResponseBodyAsStream());
        }
    };

    public OAuthRequestAsync(Verb verb, String url, OAuthService service) {
        super(verb, url, service);
    }

    public <T> Future<T> sendAsync(OAuthAsyncRequestCallback<T> callback, ResponseConverter<T> converter) {
        return this.sendAsync(callback, converter, null);
    }

    public <T> Future<T> sendAsync(OAuthAsyncRequestCallback<T> callback, ResponseConverter<T> converter, ProxyServer proxyServer) {
        AsyncHttpClient.BoundRequestBuilder boundRequestBuilder;
        ForceTypeOfHttpRequest forceTypeOfHttpRequest = ScribeJavaConfig.getForceTypeOfHttpRequests();
        if (ForceTypeOfHttpRequest.FORCE_SYNC_ONLY_HTTP_REQUESTS == forceTypeOfHttpRequest) {
            throw new OAuthException("Cannot use async operations, only sync");
        }
        OAuthService service = this.getService();
        if (ForceTypeOfHttpRequest.PREFER_SYNC_ONLY_HTTP_REQUESTS == forceTypeOfHttpRequest) {
            service.getConfig().log("Cannot use async operations, only sync");
        }
        String completeUrl = this.getCompleteUrl();
        AsyncHttpClient asyncHttpClient = service.getAsyncHttpClient();
        Map<String, String> headers = this.getHeaders();
        switch (this.getVerb()) {
            case GET: {
                boundRequestBuilder = asyncHttpClient.prepareGet(completeUrl);
                break;
            }
            case POST: {
                AsyncHttpClient.BoundRequestBuilder requestBuilder = asyncHttpClient.preparePost(completeUrl);
                if (!headers.containsKey("Content-Type")) {
                    requestBuilder = requestBuilder.addHeader("Content-Type", "application/x-www-form-urlencoded");
                }
                boundRequestBuilder = requestBuilder.setBody(this.getBodyContents());
                break;
            }
            default: {
                throw new IllegalArgumentException("message build error: unknown verb type");
            }
        }
        for (Map.Entry<String, String> header : headers.entrySet()) {
            boundRequestBuilder.addHeader(header.getKey(), header.getValue());
        }
        if (proxyServer != null) {
            boundRequestBuilder.setProxyServer(proxyServer);
        }
        return boundRequestBuilder.execute(new OAuthAsyncCompletionHandler<T>(callback, converter));
    }

    public Future<Response> sendAsync(OAuthAsyncRequestCallback<Response> callback) {
        return this.sendAsync(callback, RESPONSE_CONVERTER, null);
    }

    public Future<Response> sendAsync(OAuthAsyncRequestCallback<Response> callback, ProxyServer proxyServer) {
        return this.sendAsync(callback, RESPONSE_CONVERTER, proxyServer);
    }

    public static interface ResponseConverter<T> {
        public T convert(com.ning.http.client.Response var1) throws IOException;
    }

    private static class OAuthAsyncCompletionHandler<T>
    extends AsyncCompletionHandler<T> {
        private final OAuthAsyncRequestCallback<T> callback;
        private final ResponseConverter<T> converter;

        OAuthAsyncCompletionHandler(OAuthAsyncRequestCallback<T> callback, ResponseConverter<T> converter) {
            this.callback = callback;
            this.converter = converter;
        }

        public T onCompleted(com.ning.http.client.Response response) throws IOException {
            T t = this.converter.convert(response);
            if (this.callback != null) {
                this.callback.onCompleted(t);
            }
            return t;
        }

        public void onThrowable(Throwable t) {
            if (this.callback != null) {
                this.callback.onThrowable(t);
            }
        }
    }
}

