/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.extractors;

import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.extractors.TokenExtractor;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.utils.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OAuth2AccessTokenJsonExtractor
implements TokenExtractor<OAuth2AccessToken> {
    private static final String ACCESS_TOKEN_REGEX = "\"access_token\"\\s*:\\s*\"(\\S*?)\"";
    private static final String TOKEN_TYPE_REGEX = "\"token_type\"\\s*:\\s*\"(\\S*?)\"";
    private static final String EXPIRES_IN_REGEX = "\"expires_in\"\\s*:\\s*\"?(\\d*?)\"?\\D";
    private static final String REFRESH_TOKEN_REGEX = "\"refresh_token\"\\s*:\\s*\"(\\S*?)\"";
    private static final String SCOPE_REGEX = "\"scope\"\\s*:\\s*\"(\\S*?)\"";

    protected OAuth2AccessTokenJsonExtractor() {
    }

    public static OAuth2AccessTokenJsonExtractor instance() {
        return InstanceHolder.INSTANCE;
    }

    @Override
    public OAuth2AccessToken extract(String response) {
        Integer expiresIn;
        Preconditions.checkEmptyString(response, "Response body is incorrect. Can't extract a token from an empty string");
        String accessToken = OAuth2AccessTokenJsonExtractor.extractParameter(response, ACCESS_TOKEN_REGEX, true);
        String tokenType = OAuth2AccessTokenJsonExtractor.extractParameter(response, TOKEN_TYPE_REGEX, false);
        String expiresInString = OAuth2AccessTokenJsonExtractor.extractParameter(response, EXPIRES_IN_REGEX, false);
        try {
            expiresIn = expiresInString == null ? null : Integer.valueOf(expiresInString);
        }
        catch (NumberFormatException nfe) {
            expiresIn = null;
        }
        String refreshToken = OAuth2AccessTokenJsonExtractor.extractParameter(response, REFRESH_TOKEN_REGEX, false);
        String scope = OAuth2AccessTokenJsonExtractor.extractParameter(response, SCOPE_REGEX, false);
        return this.createToken(accessToken, tokenType, expiresIn, refreshToken, scope, response);
    }

    protected OAuth2AccessToken createToken(String accessToken, String tokenType, Integer expiresIn, String refreshToken, String scope, String response) {
        return new OAuth2AccessToken(accessToken, tokenType, expiresIn, refreshToken, scope, response);
    }

    protected static String extractParameter(String response, String regex, boolean required) throws OAuthException {
        Matcher matcher = Pattern.compile(regex).matcher(response);
        if (matcher.find()) {
            return matcher.group(1);
        }
        if (required) {
            throw new OAuthException("Response body is incorrect. Can't extract a '" + regex + "' from this: '" + response + "'", null);
        }
        return null;
    }

    private static class InstanceHolder {
        private static final OAuth2AccessTokenJsonExtractor INSTANCE = new OAuth2AccessTokenJsonExtractor();

        private InstanceHolder() {
        }
    }
}

