/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.model;

import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Parameter;
import com.github.scribejava.core.model.Verb;
import java.net.MalformedURLException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RequestTest {
    private OAuthRequest getRequest;
    private OAuthRequest postRequest;

    @Before
    public void setUp() throws MalformedURLException {
        this.postRequest = new OAuthRequest(Verb.POST, "http://example.com");
        this.postRequest.addBodyParameter("param", "value");
        this.postRequest.addBodyParameter("param with spaces", "value with spaces");
        this.getRequest = new OAuthRequest(Verb.GET, "http://example.com?qsparam=value&other+param=value+with+spaces");
    }

    @Test
    public void shouldGetQueryStringParameters() {
        Assert.assertEquals((long)2L, (long)this.getRequest.getQueryStringParams().size());
        Assert.assertEquals((long)0L, (long)this.postRequest.getQueryStringParams().size());
        Assert.assertTrue((boolean)this.getRequest.getQueryStringParams().contains(new Parameter("qsparam", "value")));
    }

    @Test
    public void shouldSetBodyParamsAndAddContentLength() {
        Assert.assertEquals((Object)"param=value&param%20with%20spaces=value%20with%20spaces", (Object)new String(this.postRequest.getByteArrayPayload()));
    }

    @Test
    public void shouldSetPayloadAndHeaders() {
        this.postRequest.setPayload("PAYLOAD");
        Assert.assertEquals((Object)"PAYLOAD", (Object)this.postRequest.getStringPayload());
    }

    @Test
    public void shouldAllowAddingQuerystringParametersAfterCreation() {
        OAuthRequest request = new OAuthRequest(Verb.GET, "http://example.com?one=val");
        request.addQuerystringParameter("two", "other val");
        request.addQuerystringParameter("more", "params");
        Assert.assertEquals((long)3L, (long)request.getQueryStringParams().size());
    }

    @Test
    public void shouldReturnTheCompleteUrl() {
        OAuthRequest request = new OAuthRequest(Verb.GET, "http://example.com?one=val");
        request.addQuerystringParameter("two", "other val");
        request.addQuerystringParameter("more", "params");
        Assert.assertEquals((Object)"http://example.com?one=val&two=other%20val&more=params", (Object)request.getCompleteUrl());
    }

    @Test
    public void shouldHandleQueryStringSpaceEncodingProperly() {
        Assert.assertTrue((boolean)this.getRequest.getQueryStringParams().contains(new Parameter("other param", "value with spaces")));
    }
}

