/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.httpclient.multipart;

import com.github.scribejava.core.httpclient.multipart.MultipartPayload;
import org.hamcrest.core.StringStartsWith;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class MultipartPayloadTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testValidCheckBoundarySyntax() {
        MultipartPayload.checkBoundarySyntax((String)"0aA'()+_,-./:=?");
        MultipartPayload.checkBoundarySyntax((String)"0aA'()+_,- ./:=?");
        MultipartPayload.checkBoundarySyntax((String)" 0aA'()+_,-./:=?");
        MultipartPayload.checkBoundarySyntax((String)"1234567890123456789012345678901234567890123456789012345678901234567890");
    }

    @Test
    public void testNonValidLastWhiteSpaceCheckBoundarySyntax() {
        String boundary = "0aA'()+_,-./:=? ";
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(StringStartsWith.startsWith((String)"{'boundary'='0aA'()+_,-./:=? '} has invaid syntax. Should be '"));
        MultipartPayload.checkBoundarySyntax((String)"0aA'()+_,-./:=? ");
    }

    @Test
    public void testNonValidEmptyCheckBoundarySyntax() {
        String boundary = "";
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(StringStartsWith.startsWith((String)"{'boundary'=''} has invaid syntax. Should be '"));
        MultipartPayload.checkBoundarySyntax((String)"");
    }

    @Test
    public void testNonValidIllegalSymbolCheckBoundarySyntax() {
        String boundary = "0aA'()+_;,-./:=? ";
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(StringStartsWith.startsWith((String)"{'boundary'='0aA'()+_;,-./:=? '} has invaid syntax. Should be '"));
        MultipartPayload.checkBoundarySyntax((String)"0aA'()+_;,-./:=? ");
    }

    @Test
    public void testNonValidTooLongCheckBoundarySyntax() {
        String boundary = "12345678901234567890123456789012345678901234567890123456789012345678901";
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(StringStartsWith.startsWith((String)"{'boundary'='12345678901234567890123456789012345678901234567890123456789012345678901'} has invaid syntax. Should be '"));
        MultipartPayload.checkBoundarySyntax((String)"12345678901234567890123456789012345678901234567890123456789012345678901");
    }

    @Test
    public void testNonValidNullCheckBoundarySyntax() {
        String boundary = null;
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(StringStartsWith.startsWith((String)("{'boundary'='" + boundary + "'} has invaid syntax. Should be '")));
        MultipartPayload.checkBoundarySyntax(boundary);
    }

    @Test
    public void testParseBoundaryFromHeader() {
        Assert.assertNull((Object)MultipartPayload.parseBoundaryFromHeader(null));
        Assert.assertEquals((Object)"0aA'()+_,-./:=?", (Object)MultipartPayload.parseBoundaryFromHeader((String)"multipart/subtype; boundary=\"0aA'()+_,-./:=?\""));
        Assert.assertEquals((Object)"0aA'()+_, -./:=?", (Object)MultipartPayload.parseBoundaryFromHeader((String)"multipart/subtype; boundary=\"0aA'()+_, -./:=?\""));
        Assert.assertEquals((Object)"0aA'()+_, -./:=?", (Object)MultipartPayload.parseBoundaryFromHeader((String)"multipart/subtype; boundary=\"0aA'()+_, -./:=? \""));
        Assert.assertEquals((Object)"0aA'()+_,-./:=?", (Object)MultipartPayload.parseBoundaryFromHeader((String)"multipart/subtype; boundary=0aA'()+_,-./:=?"));
        Assert.assertEquals((Object)"0aA'()+_, -./:=?", (Object)MultipartPayload.parseBoundaryFromHeader((String)"multipart/subtype; boundary=0aA'()+_, -./:=?"));
        Assert.assertEquals((Object)"0aA'()+_, -./:=?", (Object)MultipartPayload.parseBoundaryFromHeader((String)"multipart/subtype; boundary=0aA'()+_, -./:=? "));
        Assert.assertEquals((Object)" 0aA'()+_, -./:=?", (Object)MultipartPayload.parseBoundaryFromHeader((String)"multipart/subtype; boundary= 0aA'()+_, -./:=?"));
        Assert.assertNull((Object)MultipartPayload.parseBoundaryFromHeader((String)"multipart/subtype; boundar=0aA'()+_, -./:=? "));
        Assert.assertNull((Object)MultipartPayload.parseBoundaryFromHeader((String)"multipart/subtype; "));
        Assert.assertNull((Object)MultipartPayload.parseBoundaryFromHeader((String)"multipart/subtype;"));
        Assert.assertNull((Object)MultipartPayload.parseBoundaryFromHeader((String)"multipart/subtype"));
        Assert.assertNull((Object)MultipartPayload.parseBoundaryFromHeader((String)"multipart/subtype; boundary="));
        Assert.assertEquals((Object)"0aA'()+_,", (Object)MultipartPayload.parseBoundaryFromHeader((String)"multipart/subtype; boundary=0aA'()+_,; -./:=? "));
        Assert.assertEquals((Object)"0aA'()+_, -./:=?", (Object)MultipartPayload.parseBoundaryFromHeader((String)"multipart/subtype; boundary=\"0aA'()+_, -./:=?"));
        Assert.assertEquals((Object)"0aA'()+_, -./:=?", (Object)MultipartPayload.parseBoundaryFromHeader((String)"multipart/subtype; boundary=0aA'()+_, -./:=?\""));
        Assert.assertEquals((Object)"1234567890123456789012345678901234567890123456789012345678901234567890", (Object)MultipartPayload.parseBoundaryFromHeader((String)"multipart/subtype; boundary=1234567890123456789012345678901234567890123456789012345678901234567890"));
        Assert.assertEquals((Object)"1234567890123456789012345678901234567890123456789012345678901234567890", (Object)MultipartPayload.parseBoundaryFromHeader((String)"multipart/subtype; boundary=12345678901234567890123456789012345678901234567890123456789012345678901"));
        Assert.assertNull((Object)MultipartPayload.parseBoundaryFromHeader((String)"multipart/subtype; boundary="));
        Assert.assertNull((Object)MultipartPayload.parseBoundaryFromHeader((String)"multipart/subtype; boundary=\"\""));
        Assert.assertNull((Object)MultipartPayload.parseBoundaryFromHeader((String)"multipart/subtype; boundary=;123"));
        Assert.assertNull((Object)MultipartPayload.parseBoundaryFromHeader((String)"multipart/subtype; boundary=\"\"123"));
    }
}

