/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.extractors;

import com.github.scribejava.core.extractors.OAuth2AccessTokenJsonExtractor;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuth2AccessTokenErrorResponse;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.oauth2.OAuth2Error;
import java.io.IOException;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;

public class OAuth2AccessTokenJsonExtractorTest {
    private final OAuth2AccessTokenJsonExtractor extractor = OAuth2AccessTokenJsonExtractor.instance();

    @Test
    public void shouldParseResponse() throws IOException {
        OAuth2AccessToken token;
        String responseBody = "{ \"access_token\":\"I0122HHJKLEM21F3WLPYHDKGKZULAUO4SGMV3ABKFTDT3T3X\", \"token_type\":\"example\"}";
        try (Response response = OAuth2AccessTokenJsonExtractorTest.ok("{ \"access_token\":\"I0122HHJKLEM21F3WLPYHDKGKZULAUO4SGMV3ABKFTDT3T3X\", \"token_type\":\"example\"}");){
            token = this.extractor.extract(response);
        }
        Assert.assertEquals((Object)"I0122HHJKLEM21F3WLPYHDKGKZULAUO4SGMV3ABKFTDT3T3X", (Object)token.getAccessToken());
    }

    @Test
    public void shouldParseScopeFromResponse() throws IOException {
        OAuth2AccessToken token3;
        OAuth2AccessToken token2;
        OAuth2AccessToken token;
        String responseBody = "{ \"access_token\":\"I0122HHJKLEM21F3WLPYHDKGKZULAUO4SGMV3ABKFTDT3T4X\", \"token_type\":\"example\",\"scope\":\"s1\"}";
        try (Response response = OAuth2AccessTokenJsonExtractorTest.ok("{ \"access_token\":\"I0122HHJKLEM21F3WLPYHDKGKZULAUO4SGMV3ABKFTDT3T4X\", \"token_type\":\"example\",\"scope\":\"s1\"}");){
            token = this.extractor.extract(response);
        }
        Assert.assertEquals((Object)"I0122HHJKLEM21F3WLPYHDKGKZULAUO4SGMV3ABKFTDT3T4X", (Object)token.getAccessToken());
        Assert.assertEquals((Object)"s1", (Object)token.getScope());
        String responseBody2 = "{ \"access_token\":\"I0122HHJKLEM21F3WLPYHDKGKZULAUO4SGMV3ABKFTDT3T5X\", \"token_type\":\"example\",\"scope\":\"s1 s2\"}";
        try (Response response = OAuth2AccessTokenJsonExtractorTest.ok("{ \"access_token\":\"I0122HHJKLEM21F3WLPYHDKGKZULAUO4SGMV3ABKFTDT3T5X\", \"token_type\":\"example\",\"scope\":\"s1 s2\"}");){
            token2 = this.extractor.extract(response);
        }
        Assert.assertEquals((Object)"I0122HHJKLEM21F3WLPYHDKGKZULAUO4SGMV3ABKFTDT3T5X", (Object)token2.getAccessToken());
        Assert.assertEquals((Object)"s1 s2", (Object)token2.getScope());
        String responseBody3 = "{ \"access_token\":\"I0122HHJKLEM21F3WLPYHDKGKZULAUO4SGMV3ABKFTDT3T6X\", \"token_type\":\"example\",\"scope\":\"s3 s4\", \"refresh_token\":\"refresh_token1\"}";
        try (Response response = OAuth2AccessTokenJsonExtractorTest.ok("{ \"access_token\":\"I0122HHJKLEM21F3WLPYHDKGKZULAUO4SGMV3ABKFTDT3T6X\", \"token_type\":\"example\",\"scope\":\"s3 s4\", \"refresh_token\":\"refresh_token1\"}");){
            token3 = this.extractor.extract(response);
        }
        Assert.assertEquals((Object)"I0122HHJKLEM21F3WLPYHDKGKZULAUO4SGMV3ABKFTDT3T6X", (Object)token3.getAccessToken());
        Assert.assertEquals((Object)"s3 s4", (Object)token3.getScope());
        Assert.assertEquals((Object)"refresh_token1", (Object)token3.getRefreshToken());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionIfForNullParameters() throws IOException {
        try (Response response = OAuth2AccessTokenJsonExtractorTest.ok(null);){
            this.extractor.extract(response);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionIfForEmptyStrings() throws IOException {
        String responseBody = "";
        try (Response response = OAuth2AccessTokenJsonExtractorTest.ok("");){
            this.extractor.extract(response);
        }
    }

    @Test
    public void shouldThrowExceptionIfResponseIsError() throws IOException {
        String responseBody = "{\"error_description\":\"unknown, invalid, or expired refresh token\",\"error\":\"invalid_grant\"}";
        try (Response response = OAuth2AccessTokenJsonExtractorTest.error("{\"error_description\":\"unknown, invalid, or expired refresh token\",\"error\":\"invalid_grant\"}");){
            this.extractor.extract(response);
            Assert.fail();
        }
        catch (OAuth2AccessTokenErrorResponse oaer) {
            Assert.assertEquals((Object)OAuth2Error.INVALID_GRANT, (Object)oaer.getError());
            Assert.assertEquals((Object)"unknown, invalid, or expired refresh token", (Object)oaer.getErrorDescription());
        }
    }

    @Test
    public void testEscapedJsonInResponse() throws IOException {
        OAuth2AccessToken token;
        String responseBody = "{ \"access_token\":\"I0122HKLEM2\\/MV3ABKFTDT3T5X\",\"token_type\":\"example\"}";
        try (Response response = OAuth2AccessTokenJsonExtractorTest.ok("{ \"access_token\":\"I0122HKLEM2\\/MV3ABKFTDT3T5X\",\"token_type\":\"example\"}");){
            token = this.extractor.extract(response);
        }
        Assert.assertEquals((Object)"I0122HKLEM2/MV3ABKFTDT3T5X", (Object)token.getAccessToken());
    }

    private static Response ok(String body) {
        return new Response(200, null, Collections.emptyMap(), body);
    }

    private static Response error(String body) {
        return new Response(400, null, Collections.emptyMap(), body);
    }
}

