/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.httpclient.multipart;

import com.github.scribejava.core.httpclient.multipart.BodyPartPayload;
import com.github.scribejava.core.httpclient.multipart.ByteArrayBodyPartPayload;
import com.github.scribejava.core.httpclient.multipart.FileByteArrayBodyPartPayload;
import com.github.scribejava.core.httpclient.multipart.MultipartPayload;
import com.github.scribejava.core.httpclient.multipart.MultipartUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;

public class MultipartUtilsTest {
    @Test
    public void testEmptyMultipartPayload() throws IOException {
        MultipartPayload mP = new MultipartPayload();
        StringBuilder headersString = new StringBuilder();
        for (Map.Entry header : mP.getHeaders().entrySet()) {
            headersString.append((String)header.getKey()).append(": ").append((String)header.getValue()).append("\r\n");
        }
        Assert.assertEquals((Object)("Content-Type: multipart/form-data; boundary=\"" + mP.getBoundary() + "\"\r\n"), (Object)headersString.toString());
        Assert.assertEquals((Object)"", (Object)MultipartUtils.getPayload((MultipartPayload)mP).toString());
    }

    @Test
    public void testSimpleMultipartPayload() throws IOException {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.put("X-Header", "X-Value");
        headers.put("Content-Disposition", "Content-Disposition-Value");
        MultipartPayload mP = new MultipartPayload("mixed", "simple boundary", headers);
        mP.setPreamble("This is the preamble.  It is to be ignored, though it\nis a handy place for composition agents to include an\nexplanatory note to non-MIME conformant readers.");
        mP.addBodyPart((BodyPartPayload)new ByteArrayBodyPartPayload("This is implicitly typed plain US-ASCII text.\nIt does NOT end with a linebreak.".getBytes()));
        ByteArrayBodyPartPayload bP = new ByteArrayBodyPartPayload("This is explicitly typed plain US-ASCII text.\nIt DOES end with a linebreak.\n".getBytes(), Collections.singletonMap("Content-Type", "text/plain; charset=us-ascii"));
        mP.addBodyPart((BodyPartPayload)bP);
        mP.setEpilogue("This is the epilogue.  It is also to be ignored.");
        StringBuilder headersString = new StringBuilder();
        for (Map.Entry header : mP.getHeaders().entrySet()) {
            headersString.append((String)header.getKey()).append(": ").append((String)header.getValue()).append("\r\n");
        }
        Assert.assertEquals((Object)"X-Header: X-Value\r\nContent-Disposition: Content-Disposition-Value\r\nContent-Type: multipart/mixed; boundary=\"simple boundary\"\r\n", (Object)headersString.toString());
        Assert.assertEquals((Object)"This is the preamble.  It is to be ignored, though it\nis a handy place for composition agents to include an\nexplanatory note to non-MIME conformant readers.\r\n--simple boundary\r\n\r\nThis is implicitly typed plain US-ASCII text.\nIt does NOT end with a linebreak.\r\n--simple boundary\r\nContent-Type: text/plain; charset=us-ascii\r\n\r\nThis is explicitly typed plain US-ASCII text.\nIt DOES end with a linebreak.\n\r\n--simple boundary--\r\nThis is the epilogue.  It is also to be ignored.", (Object)MultipartUtils.getPayload((MultipartPayload)mP).toString());
    }

    @Test
    public void testCRLFMultipartPayload() throws IOException {
        MultipartPayload mP = new MultipartPayload("simple-boundary");
        mP.addBodyPart((BodyPartPayload)new ByteArrayBodyPartPayload("It does NOT end with a linebreak.".getBytes()));
        mP.addBodyPart((BodyPartPayload)new ByteArrayBodyPartPayload("It does end with a \\r linebreak.\r".getBytes()));
        mP.addBodyPart((BodyPartPayload)new ByteArrayBodyPartPayload("It does end with a \\n linebreak.\n".getBytes()));
        mP.addBodyPart((BodyPartPayload)new ByteArrayBodyPartPayload("It does end with a \\r\\n linebreak.\r\n".getBytes()));
        mP.addBodyPart((BodyPartPayload)new ByteArrayBodyPartPayload("the last one".getBytes()));
        StringBuilder headersString = new StringBuilder();
        for (Map.Entry header : mP.getHeaders().entrySet()) {
            headersString.append((String)header.getKey()).append(": ").append((String)header.getValue()).append("\r\n");
        }
        Assert.assertEquals((Object)"Content-Type: multipart/form-data; boundary=\"simple-boundary\"\r\n", (Object)headersString.toString());
        Assert.assertEquals((Object)"--simple-boundary\r\n\r\nIt does NOT end with a linebreak.\r\n--simple-boundary\r\n\r\nIt does end with a \\r linebreak.\r\r\n--simple-boundary\r\n\r\nIt does end with a \\n linebreak.\n\r\n--simple-boundary\r\n\r\nIt does end with a \\r\\n linebreak.\r\n\r\n--simple-boundary\r\n\r\nthe last one\r\n--simple-boundary--", (Object)MultipartUtils.getPayload((MultipartPayload)mP).toString());
    }

    @Test
    public void testFileByteArrayBodyPartPayloadMultipartPayload() throws IOException {
        MultipartPayload mP = new MultipartPayload("testFileByteArrayBodyPartPayloadMultipartPayload boundary");
        mP.addBodyPart((BodyPartPayload)new FileByteArrayBodyPartPayload("fileContent".getBytes(), "name", "filename.ext"));
        StringBuilder headersString = new StringBuilder();
        for (Map.Entry header : mP.getHeaders().entrySet()) {
            headersString.append((String)header.getKey()).append(": ").append((String)header.getValue()).append("\r\n");
        }
        Assert.assertEquals((Object)"Content-Type: multipart/form-data; boundary=\"testFileByteArrayBodyPartPayloadMultipartPayload boundary\"\r\n", (Object)headersString.toString());
        Assert.assertEquals((Object)"--testFileByteArrayBodyPartPayloadMultipartPayload boundary\r\nContent-Disposition: form-data; name=\"name\"; filename=\"filename.ext\"\r\n\r\nfileContent\r\n--testFileByteArrayBodyPartPayloadMultipartPayload boundary--", (Object)MultipartUtils.getPayload((MultipartPayload)mP).toString());
    }

    @Test
    public void testComplexMultipartPayload() throws IOException {
        MultipartPayload mP = new MultipartPayload("mixed", "unique-boundary-1");
        mP.setPreamble("This is the preamble area of a multipart message.\nMail readers that understand multipart format\nshould ignore this preamble.\n\nIf you are reading this text, you might want to\nconsider changing to a mail reader that understands\nhow to properly display multipart messages.\n");
        mP.addBodyPart((BodyPartPayload)new ByteArrayBodyPartPayload("... Some text appears here ...".getBytes()));
        mP.addBodyPart((BodyPartPayload)new ByteArrayBodyPartPayload("This could have been part of the previous part, but\nillustrates explicit versus implicit typing of body\nparts.\n".getBytes(), "text/plain; charset=US-ASCII"));
        MultipartPayload innerMP = new MultipartPayload("parallel", "unique-boundary-2");
        mP.addBodyPart(innerMP);
        LinkedHashMap<String, String> audioHeaders = new LinkedHashMap<String, String>();
        audioHeaders.put("Content-Type", "audio/basic");
        audioHeaders.put("Content-Transfer-Encoding", "base64");
        innerMP.addBodyPart((BodyPartPayload)new ByteArrayBodyPartPayload("... base64-encoded 8000 Hz single-channel\n    mu-law-format audio data goes here ...".getBytes(), audioHeaders));
        LinkedHashMap<String, String> imageHeaders = new LinkedHashMap<String, String>();
        imageHeaders.put("Content-Type", "image/jpeg");
        imageHeaders.put("Content-Transfer-Encoding", "base64");
        innerMP.addBodyPart((BodyPartPayload)new ByteArrayBodyPartPayload("... base64-encoded image data goes here ...".getBytes(), imageHeaders));
        mP.addBodyPart((BodyPartPayload)new ByteArrayBodyPartPayload("This is <bold><italic>enriched.</italic></bold>\n<smaller>as defined in RFC 1896</smaller>\n\nIsn't it\n<bigger><bigger>cool?</bigger></bigger>\n".getBytes(), "text/enriched"));
        mP.addBodyPart((BodyPartPayload)new ByteArrayBodyPartPayload("From: (mailbox in US-ASCII)\nTo: (address in US-ASCII)\nSubject: (subject in US-ASCII)\nContent-Type: Text/plain; charset=ISO-8859-1\nContent-Transfer-Encoding: Quoted-printable\n\n... Additional text in ISO-8859-1 goes here ...\n".getBytes(), "message/rfc822"));
        StringBuilder headersString = new StringBuilder();
        for (Map.Entry header : mP.getHeaders().entrySet()) {
            headersString.append((String)header.getKey()).append(": ").append((String)header.getValue()).append("\r\n");
        }
        Assert.assertEquals((Object)"Content-Type: multipart/mixed; boundary=\"unique-boundary-1\"\r\n", (Object)headersString.toString());
        Assert.assertEquals((Object)"This is the preamble area of a multipart message.\nMail readers that understand multipart format\nshould ignore this preamble.\n\nIf you are reading this text, you might want to\nconsider changing to a mail reader that understands\nhow to properly display multipart messages.\n\r\n--unique-boundary-1\r\n\r\n... Some text appears here ...\r\n--unique-boundary-1\r\nContent-Type: text/plain; charset=US-ASCII\r\n\r\nThis could have been part of the previous part, but\nillustrates explicit versus implicit typing of body\nparts.\n\r\n--unique-boundary-1\r\nContent-Type: multipart/parallel; boundary=\"unique-boundary-2\"\r\n\r\n--unique-boundary-2\r\nContent-Type: audio/basic\r\nContent-Transfer-Encoding: base64\r\n\r\n... base64-encoded 8000 Hz single-channel\n    mu-law-format audio data goes here ...\r\n--unique-boundary-2\r\nContent-Type: image/jpeg\r\nContent-Transfer-Encoding: base64\r\n\r\n... base64-encoded image data goes here ...\r\n--unique-boundary-2--\r\n--unique-boundary-1\r\nContent-Type: text/enriched\r\n\r\nThis is <bold><italic>enriched.</italic></bold>\n<smaller>as defined in RFC 1896</smaller>\n\nIsn't it\n<bigger><bigger>cool?</bigger></bigger>\n\r\n--unique-boundary-1\r\nContent-Type: message/rfc822\r\n\r\nFrom: (mailbox in US-ASCII)\nTo: (address in US-ASCII)\nSubject: (subject in US-ASCII)\nContent-Type: Text/plain; charset=ISO-8859-1\nContent-Transfer-Encoding: Quoted-printable\n\n... Additional text in ISO-8859-1 goes here ...\n\r\n--unique-boundary-1--", (Object)MultipartUtils.getPayload((MultipartPayload)mP).toString());
    }

    @Test
    public void testParseBoundaryFromHeader() {
        Assert.assertNull((Object)MultipartUtils.parseBoundaryFromHeader(null));
        Assert.assertEquals((Object)"0aA'()+_,-./:=?", (Object)MultipartUtils.parseBoundaryFromHeader((String)"multipart/subtype; boundary=\"0aA'()+_,-./:=?\""));
        Assert.assertEquals((Object)"0aA'()+_, -./:=?", (Object)MultipartUtils.parseBoundaryFromHeader((String)"multipart/subtype; boundary=\"0aA'()+_, -./:=?\""));
        Assert.assertEquals((Object)"0aA'()+_, -./:=?", (Object)MultipartUtils.parseBoundaryFromHeader((String)"multipart/subtype; boundary=\"0aA'()+_, -./:=? \""));
        Assert.assertEquals((Object)"0aA'()+_,-./:=?", (Object)MultipartUtils.parseBoundaryFromHeader((String)"multipart/subtype; boundary=0aA'()+_,-./:=?"));
        Assert.assertEquals((Object)"0aA'()+_, -./:=?", (Object)MultipartUtils.parseBoundaryFromHeader((String)"multipart/subtype; boundary=0aA'()+_, -./:=?"));
        Assert.assertEquals((Object)"0aA'()+_, -./:=?", (Object)MultipartUtils.parseBoundaryFromHeader((String)"multipart/subtype; boundary=0aA'()+_, -./:=? "));
        Assert.assertEquals((Object)" 0aA'()+_, -./:=?", (Object)MultipartUtils.parseBoundaryFromHeader((String)"multipart/subtype; boundary= 0aA'()+_, -./:=?"));
        Assert.assertNull((Object)MultipartUtils.parseBoundaryFromHeader((String)"multipart/subtype; boundar=0aA'()+_, -./:=? "));
        Assert.assertNull((Object)MultipartUtils.parseBoundaryFromHeader((String)"multipart/subtype; "));
        Assert.assertNull((Object)MultipartUtils.parseBoundaryFromHeader((String)"multipart/subtype;"));
        Assert.assertNull((Object)MultipartUtils.parseBoundaryFromHeader((String)"multipart/subtype"));
        Assert.assertNull((Object)MultipartUtils.parseBoundaryFromHeader((String)"multipart/subtype; boundary="));
        Assert.assertEquals((Object)"0aA'()+_,", (Object)MultipartUtils.parseBoundaryFromHeader((String)"multipart/subtype; boundary=0aA'()+_,; -./:=? "));
        Assert.assertEquals((Object)"0aA'()+_, -./:=?", (Object)MultipartUtils.parseBoundaryFromHeader((String)"multipart/subtype; boundary=\"0aA'()+_, -./:=?"));
        Assert.assertEquals((Object)"0aA'()+_, -./:=?", (Object)MultipartUtils.parseBoundaryFromHeader((String)"multipart/subtype; boundary=0aA'()+_, -./:=?\""));
        Assert.assertEquals((Object)"1234567890123456789012345678901234567890123456789012345678901234567890", (Object)MultipartUtils.parseBoundaryFromHeader((String)"multipart/subtype; boundary=1234567890123456789012345678901234567890123456789012345678901234567890"));
        Assert.assertEquals((Object)"1234567890123456789012345678901234567890123456789012345678901234567890", (Object)MultipartUtils.parseBoundaryFromHeader((String)"multipart/subtype; boundary=12345678901234567890123456789012345678901234567890123456789012345678901"));
        Assert.assertNull((Object)MultipartUtils.parseBoundaryFromHeader((String)"multipart/subtype; boundary="));
        Assert.assertNull((Object)MultipartUtils.parseBoundaryFromHeader((String)"multipart/subtype; boundary=\"\""));
        Assert.assertNull((Object)MultipartUtils.parseBoundaryFromHeader((String)"multipart/subtype; boundary=;123"));
        Assert.assertNull((Object)MultipartUtils.parseBoundaryFromHeader((String)"multipart/subtype; boundary=\"\"123"));
    }

    @Test
    public void testValidCheckBoundarySyntax() {
        MultipartUtils.checkBoundarySyntax((String)"0aA'()+_,-./:=?");
        MultipartUtils.checkBoundarySyntax((String)"0aA'()+_,- ./:=?");
        MultipartUtils.checkBoundarySyntax((String)" 0aA'()+_,-./:=?");
        MultipartUtils.checkBoundarySyntax((String)"1234567890123456789012345678901234567890123456789012345678901234567890");
    }

    @Test
    public void testNonValidLastWhiteSpaceCheckBoundarySyntax() {
        MultipartUtilsTest.testNotValidBoundary("0aA'()+_,-./:=? ");
    }

    @Test
    public void testNonValidEmptyCheckBoundarySyntax() {
        MultipartUtilsTest.testNotValidBoundary("");
    }

    @Test
    public void testNonValidIllegalSymbolCheckBoundarySyntax() {
        MultipartUtilsTest.testNotValidBoundary("0aA'()+_;,-./:=? ");
    }

    @Test
    public void testNonValidTooLongCheckBoundarySyntax() {
        MultipartUtilsTest.testNotValidBoundary("12345678901234567890123456789012345678901234567890123456789012345678901");
    }

    @Test
    public void testNonValidNullCheckBoundarySyntax() {
        MultipartUtilsTest.testNotValidBoundary(null);
    }

    private static void testNotValidBoundary(final String boundary) {
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                MultipartUtils.checkBoundarySyntax((String)boundary);
            }
        });
        Assert.assertTrue((boolean)thrown.getMessage().startsWith("{'boundary'='" + boundary + "'} has invalid syntax. Should be '"));
    }
}

