/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevtech.cloud.storage.spring.service.impl;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.util.IOUtils;
import com.github.sevtech.cloud.storage.spring.bean.DeleteFileRequest;
import com.github.sevtech.cloud.storage.spring.bean.DeleteFileResponse;
import com.github.sevtech.cloud.storage.spring.bean.GetFileRequest;
import com.github.sevtech.cloud.storage.spring.bean.GetFileResponse;
import com.github.sevtech.cloud.storage.spring.bean.UploadFileRequest;
import com.github.sevtech.cloud.storage.spring.bean.UploadFileResponse;
import com.github.sevtech.cloud.storage.spring.exception.NoBucketException;
import com.github.sevtech.cloud.storage.spring.service.AbstractStorageService;
import com.github.sevtech.cloud.storage.spring.service.StorageService;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.util.StringUtils;

public class AwsS3Service
extends AbstractStorageService
implements StorageService {
    private static final Logger log = LoggerFactory.getLogger(AwsS3Service.class);
    @Value(value="${aws.s3.bucket.name}")
    private String defaultBucketName;
    private AmazonS3 awsS3Client;

    public AwsS3Service(AmazonS3 awsS3Client) {
        this.awsS3Client = awsS3Client;
    }

    @Override
    public UploadFileResponse uploadFile(UploadFileRequest request) {
        UploadFileResponse result;
        try {
            InputStream streamToUpload = this.clone(request.getStream());
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength((long)IOUtils.toByteArray((InputStream)request.getStream()).length);
            if (!StringUtils.isEmpty((Object)request.getContentType())) {
                metadata.setContentType(request.getContentType());
                metadata.setCacheControl("s-maxage");
            }
            PutObjectRequest putObjectRequest = new PutObjectRequest(this.getBucketName(request.getBucketName(), this.defaultBucketName), this.getFilePath(request), streamToUpload, metadata).withCannedAcl(request.getAccessControl());
            log.debug("Uploading file to {}", (Object)this.getFilePath(request));
            this.awsS3Client.putObject(putObjectRequest);
            result = UploadFileResponse.builder().fileName(request.getName()).status(200).build();
        }
        catch (AmazonServiceException ase) {
            this.showAmazonServiceExceptionUploadFileLogs(ase);
            result = UploadFileResponse.builder().fileName(request.getName()).status(500).cause(ase.getErrorMessage()).exception((Exception)((Object)ase)).build();
        }
        catch (AmazonClientException ace) {
            this.showAmazonClientExceptionUploadFileLogs(ace);
            result = UploadFileResponse.builder().fileName(request.getName()).status(500).cause(ace.getMessage()).exception((Exception)((Object)ace)).build();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result = UploadFileResponse.builder().fileName(request.getName()).status(500).cause(e.getMessage()).exception(e).build();
        }
        return result;
    }

    @Override
    @Async
    public Future<UploadFileResponse> uploadFileAsync(UploadFileRequest request) {
        return new AsyncResult((Object)this.uploadFile(request));
    }

    @Override
    public GetFileResponse getFile(GetFileRequest request) {
        GetFileResponse result;
        log.info("Reading file from AmazonS3 {}", (Object)request.getPath());
        try (S3Object s3Object = this.awsS3Client.getObject(new GetObjectRequest(this.getBucketName(request.getBucketName(), this.defaultBucketName), request.getPath()));){
            byte[] file = IOUtils.toByteArray((InputStream)s3Object.getObjectContent());
            result = GetFileResponse.builder().content(file).status(200).build();
        }
        catch (NoBucketException | IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            result = GetFileResponse.builder().cause(e.getMessage()).exception(e).status(500).build();
        }
        return result;
    }

    @Override
    public DeleteFileResponse deleteFile(DeleteFileRequest request) {
        DeleteFileResponse result;
        log.info("Deleting file from path {}", (Object)request.getPath());
        try {
            DeleteObjectRequest deleteObjectRequest = new DeleteObjectRequest(this.getBucketName(request.getBucketName(), this.defaultBucketName), request.getPath());
            this.awsS3Client.deleteObject(deleteObjectRequest);
            result = DeleteFileResponse.builder().result(true).status(200).build();
        }
        catch (AmazonServiceException ase) {
            this.showAmazonServiceExceptionUploadFileLogs(ase);
            result = DeleteFileResponse.builder().cause(ase.getMessage()).exception((Exception)((Object)ase)).status(500).build();
        }
        catch (AmazonClientException ace) {
            this.showAmazonClientExceptionUploadFileLogs(ace);
            result = DeleteFileResponse.builder().cause(ace.getMessage()).exception((Exception)((Object)ace)).status(500).build();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result = DeleteFileResponse.builder().cause(e.getMessage()).exception(e).status(500).build();
        }
        return result;
    }

    private void showAmazonServiceExceptionUploadFileLogs(AmazonServiceException ase) {
        log.error("Caught an AmazonServiceException, which means your request made it to Amazon S3, but was rejected with an error response for some reason.");
        log.error("Error Message:    {}", (Object)ase.getMessage());
        log.error("HTTP Status Code: {}", (Object)ase.getStatusCode());
        log.error("AWS Error Code:   {}", (Object)ase.getErrorCode());
        log.error("Error Type:       {}", (Object)ase.getErrorType());
        log.error("Request ID:       {}", (Object)ase.getRequestId());
    }

    private void showAmazonClientExceptionUploadFileLogs(AmazonClientException ace) {
        log.error("Caught an AmazonClientException, which means the client encountered an internal error while trying to communicate with S3, such as not being able to access the network.");
        log.error("Error Message: " + ace.getMessage());
    }
}

