/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevtech.cloud.storage.spring.model;

import com.amazonaws.services.s3.model.CannedAccessControlList;
import java.io.InputStream;

public class UploadFileRequest {
    private InputStream stream;
    private String folder;
    private String name;
    private String contentType;
    private String bucketName;
    private CannedAccessControlList accessControl;

    private static CannedAccessControlList $default$accessControl() {
        return CannedAccessControlList.Private;
    }

    UploadFileRequest(InputStream stream, String folder, String name, String contentType, String bucketName, CannedAccessControlList accessControl) {
        this.stream = stream;
        this.folder = folder;
        this.name = name;
        this.contentType = contentType;
        this.bucketName = bucketName;
        this.accessControl = accessControl;
    }

    public static UploadFileRequestBuilder builder() {
        return new UploadFileRequestBuilder();
    }

    public InputStream getStream() {
        return this.stream;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getName() {
        return this.name;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public CannedAccessControlList getAccessControl() {
        return this.accessControl;
    }

    public static class UploadFileRequestBuilder {
        private InputStream stream;
        private String folder;
        private String name;
        private String contentType;
        private String bucketName;
        private boolean accessControl$set;
        private CannedAccessControlList accessControl$value;

        UploadFileRequestBuilder() {
        }

        public UploadFileRequestBuilder stream(InputStream stream) {
            this.stream = stream;
            return this;
        }

        public UploadFileRequestBuilder folder(String folder) {
            this.folder = folder;
            return this;
        }

        public UploadFileRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public UploadFileRequestBuilder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public UploadFileRequestBuilder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public UploadFileRequestBuilder accessControl(CannedAccessControlList accessControl) {
            this.accessControl$value = accessControl;
            this.accessControl$set = true;
            return this;
        }

        public UploadFileRequest build() {
            CannedAccessControlList accessControl$value = this.accessControl$value;
            if (!this.accessControl$set) {
                accessControl$value = UploadFileRequest.$default$accessControl();
            }
            return new UploadFileRequest(this.stream, this.folder, this.name, this.contentType, this.bucketName, accessControl$value);
        }

        public String toString() {
            return "UploadFileRequest.UploadFileRequestBuilder(stream=" + this.stream + ", folder=" + this.folder + ", name=" + this.name + ", contentType=" + this.contentType + ", bucketName=" + this.bucketName + ", accessControl$value=" + this.accessControl$value + ")";
        }
    }
}

