/*
 * Decompiled with CFR 0.152.
 */
package com.github.shoothzj.javatool.http.async;

import com.github.shoothzj.javatool.http.async.AsyncHttpPool;
import com.github.shoothzj.javatool.http.async.HttpCallback;
import com.github.shoothzj.javatool.http.async.PoolConfigBuilder;
import java.net.URI;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncHttpService {
    private static final Logger log = LoggerFactory.getLogger(AsyncHttpService.class);
    static final AsyncHttpPool asyncHttpPool = new AsyncHttpPool(new PoolConfigBuilder().build());

    public static void sendHttpAsyncProxy(HttpUriRequest httpUriRequest, HttpCallback httpCallback) throws Exception {
        HttpHost httpHost;
        URI uri = httpUriRequest.getURI();
        if (uri.getScheme().equalsIgnoreCase("http")) {
            httpHost = new HttpHost("127.0.0.1", 10297);
        } else if (uri.getScheme().equalsIgnoreCase("https")) {
            httpHost = new HttpHost("127.0.0.1", 1028);
        } else {
            throw new IllegalArgumentException(String.format("Scheme is not legal!, uri is %s", uri));
        }
        httpUriRequest.setHeader("Cookie", "I am a Cookie");
        asyncHttpPool.sendHttpAsyncProxy(httpHost, httpUriRequest, httpCallback);
    }
}

