/*
 * Decompiled with CFR 0.152.
 */
package com.github.shoothzj.javatool.http.sync;

import com.github.shoothzj.javatool.http.async.PoolConfig;
import com.github.shoothzj.javatool.util.ExceptionUtil;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncHttpPool {
    private static final Logger log = LoggerFactory.getLogger(SyncHttpPool.class);
    private CloseableHttpClient client;

    public SyncHttpPool(PoolConfig poolConfig) {
        try {
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
            connectionManager.setMaxTotal(poolConfig.getMaxConnects());
            connectionManager.setDefaultMaxPerRoute(poolConfig.getMaxConnectPerRoute());
            this.client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(poolConfig.getTcpConnectTimeout()).setSocketTimeout(poolConfig.getSocketTimeout()).build()).disableCookieManagement().build();
        }
        catch (Exception e) {
            log.error("Construct http async pool failed, due to ", (Object)ExceptionUtil.getException(e));
            throw new IllegalArgumentException();
        }
    }

    public CloseableHttpResponse send(HttpUriRequest httpUriRequest) throws Exception {
        return this.client.execute(httpUriRequest);
    }
}

