/*
 * Decompiled with CFR 0.152.
 */
package com.github.shoothzj.javatool.http.sync;

import com.github.shoothzj.javatool.http.HttpAkResponse;
import com.github.shoothzj.javatool.http.async.PoolConfigBuilder;
import com.github.shoothzj.javatool.http.sync.SyncHttpPool;
import com.github.shoothzj.javatool.util.ExceptionUtil;
import com.github.shoothzj.javatool.util.HttpUtil;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncHttpService {
    private static final Logger log = LoggerFactory.getLogger(SyncHttpService.class);
    static final SyncHttpPool syncHttpPool = new SyncHttpPool(new PoolConfigBuilder().build());

    public static Optional<HttpAkResponse> sendHttpRequest(HttpUriRequest httpUriRequest) {
        try {
            CloseableHttpResponse httpResponse = syncHttpPool.send(httpUriRequest);
            HttpAkResponse akResponse = new HttpAkResponse();
            akResponse.setCode(httpResponse.getStatusLine().getStatusCode());
            akResponse.setHeaderMap(HttpUtil.convert(httpResponse.getAllHeaders()));
            akResponse.setResponse(EntityUtils.toString((HttpEntity)httpResponse.getEntity()));
            return Optional.of(akResponse);
        }
        catch (Exception e) {
            log.error("http execute error, exception is {}", (Object)ExceptionUtil.getException(e));
            return Optional.empty();
        }
    }
}

