/*
 * Decompiled with CFR 0.152.
 */
package com.github.shoothzj.javatool.http.async;

import com.github.shoothzj.javatool.http.PoolConfig;
import com.github.shoothzj.javatool.http.async.HttpCallback;
import com.github.shoothzj.javatool.http.async.handler.BasicHandler;
import com.github.shoothzj.javatool.util.ExceptionUtil;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncHttpPool {
    private static final Logger log = LoggerFactory.getLogger(AsyncHttpPool.class);
    private CloseableHttpAsyncClient asyncClient;
    private Executor executor = Executors.newFixedThreadPool(10);

    public AsyncHttpPool(PoolConfig poolConfig) {
        try {
            Registry sessionStrategyRegistry = RegistryBuilder.create().register("http", (Object)NoopIOSessionStrategy.INSTANCE).build();
            IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setIoThreadCount(Runtime.getRuntime().availableProcessors()).setConnectTimeout(poolConfig.getTcpConnectTimeout()).setSoTimeout(poolConfig.getSocketTimeout()).setSoReuseAddress(true).setSoKeepAlive(true).setSoLinger(0).build();
            DefaultConnectingIOReactor connectingIOReactor = new DefaultConnectingIOReactor(ioReactorConfig);
            PoolingNHttpClientConnectionManager connectionManager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)connectingIOReactor, sessionStrategyRegistry);
            connectionManager.setMaxTotal(poolConfig.getMaxConnects());
            connectionManager.setDefaultMaxPerRoute(poolConfig.getMaxConnectPerRoute());
            this.asyncClient = HttpAsyncClients.custom().setConnectionManager((NHttpClientConnectionManager)connectionManager).setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(poolConfig.getTcpConnectTimeout()).setSocketTimeout(poolConfig.getSocketTimeout()).build()).disableCookieManagement().build();
            this.asyncClient.start();
        }
        catch (Exception e) {
            log.error("Construct http async pool failed, due to ", (Object)ExceptionUtil.getException(e));
            throw new IllegalArgumentException();
        }
    }

    public void sendHttpAsync(HttpUriRequest httpUriRequest, HttpCallback httpCallback) throws Exception {
        this.asyncClient.execute(httpUriRequest, (FutureCallback)new BasicHandler(this.executor, httpCallback));
    }

    public void sendHttpAsyncProxy(HttpHost httpHost, HttpUriRequest httpUriRequest, HttpCallback httpCallback) throws Exception {
        this.asyncClient.execute(httpHost, (HttpRequest)httpUriRequest, (FutureCallback)new BasicHandler(this.executor, httpCallback));
    }
}

