/*
 * Decompiled with CFR 0.152.
 */
package com.github.shoothzj.javatool.http.sync;

import com.github.shoothzj.javatool.http.HttpAkResponse;
import com.github.shoothzj.javatool.http.PoolConfigBuilder;
import com.github.shoothzj.javatool.http.sync.SyncHttpPool;
import com.github.shoothzj.javatool.tool.PropertyTool;
import com.github.shoothzj.javatool.util.ExceptionUtil;
import com.github.shoothzj.javatool.util.HttpUtil;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncHttpService {
    private static final Logger log = LoggerFactory.getLogger(SyncHttpService.class);
    static final SyncHttpPool syncHttpPool;

    public static Optional<HttpAkResponse> sendHttpRequest(HttpUriRequest httpUriRequest) {
        try {
            CloseableHttpResponse httpResponse = syncHttpPool.send(httpUriRequest);
            HttpAkResponse akResponse = new HttpAkResponse();
            akResponse.setCode(httpResponse.getStatusLine().getStatusCode());
            akResponse.setHeaderMap(HttpUtil.convert(httpResponse.getAllHeaders()));
            akResponse.setResponse(EntityUtils.toString((HttpEntity)httpResponse.getEntity()));
            return Optional.of(akResponse);
        }
        catch (Exception e) {
            log.error("http execute error, exception is {}", (Object)ExceptionUtil.getException(e));
            return Optional.empty();
        }
    }

    static {
        PoolConfigBuilder poolConfigBuilder = new PoolConfigBuilder();
        Integer tcpTimeout = PropertyTool.readInt("http.sync.tcpConnectTimeout");
        Integer socketTimeout = PropertyTool.readInt("http.sync.socketTimeout");
        Integer maxConnect = PropertyTool.readInt("http.sync.maxConnects");
        Integer connectPerRoute = PropertyTool.readInt("http.sync.maxConnectPerRoute");
        if (tcpTimeout != null) {
            poolConfigBuilder.tcpConnectTimeout(tcpTimeout);
        }
        if (socketTimeout != null) {
            poolConfigBuilder.socketTimeout(socketTimeout);
        }
        if (maxConnect != null) {
            poolConfigBuilder.maxConnects(maxConnect);
        }
        if (connectPerRoute != null) {
            poolConfigBuilder.maxConnectPerRoute(connectPerRoute);
        }
        syncHttpPool = new SyncHttpPool(poolConfigBuilder.build());
    }
}

