/*
 * Decompiled with CFR 0.152.
 */
package com.github.shoothzj.javatool.tool;

import com.github.shoothzj.javatool.tool.FileTool;
import com.github.shoothzj.javatool.tool.StringTool;
import java.io.FileInputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyTool {
    private static final Logger log = LoggerFactory.getLogger(PropertyTool.class);
    private static final String propertyFile = "shoot.properties";
    private static final Properties properties;
    private static final Properties testProperties;
    public static volatile boolean testEnabled;
    public static boolean isTestLoaded;

    public static Double readDouble(String key) {
        String value = PropertyTool.readString(key);
        if (StringTool.isEmpty((CharSequence)value)) {
            return null;
        }
        return Double.parseDouble(value);
    }

    public static Float readFloat(String key) {
        String value = PropertyTool.readString(key);
        if (StringTool.isEmpty((CharSequence)value)) {
            return null;
        }
        return Float.valueOf(Float.parseFloat(value));
    }

    public static Integer readInt(String key) {
        String value = PropertyTool.readString(key);
        if (StringTool.isEmpty((CharSequence)value)) {
            return null;
        }
        return Integer.parseInt(value);
    }

    public static Short readShort(String key) {
        String value = PropertyTool.readString(key);
        if (StringTool.isEmpty((CharSequence)value)) {
            return null;
        }
        return Short.parseShort(value);
    }

    public static Byte readByte(String key) {
        String value = PropertyTool.readString(key);
        if (StringTool.isEmpty((CharSequence)value)) {
            return null;
        }
        return Byte.parseByte(value);
    }

    public static String readString(String key) {
        String value;
        if (isTestLoaded && testEnabled && StringTool.isNotEmpty((CharSequence)(value = (String)testProperties.get(key)))) {
            return value;
        }
        return (String)properties.get(key);
    }

    static {
        testEnabled = false;
        isTestLoaded = false;
        properties = new Properties();
        try {
            properties.load(new FileInputStream(FileTool.getFilePath(propertyFile)));
        }
        catch (Exception e) {
            log.error("load properties error, exception is {}", (Throwable)e);
            throw new RuntimeException();
        }
        testProperties = new Properties();
        try {
            testProperties.load(new FileInputStream(System.getProperty("user.home") + "/test.properties"));
            isTestLoaded = true;
        }
        catch (Exception e) {
            log.error("Test properties load error, do nothing {}", (Throwable)e);
        }
    }
}

