/*
 * Decompiled with CFR 0.152.
 */
package com.github.shoothzj.javatool.config;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigProperties {
    private static final Logger log = LoggerFactory.getLogger(ConfigProperties.class);
    private final Properties properties = new Properties();
    private final String dstFileName;

    public ConfigProperties(String originFile, String dstFileName) {
        try (FileInputStream fis = new FileInputStream(originFile);){
            this.properties.load(fis);
        }
        catch (Exception e) {
            throw new IllegalStateException("read properties from file failed ", e);
        }
        this.dstFileName = dstFileName;
    }

    public void set(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public void write() {
        try (FileOutputStream fos = new FileOutputStream(this.dstFileName);){
            this.properties.store(fos, "");
        }
        catch (Exception e) {
            throw new IllegalStateException("write config file failed ", e);
        }
    }
}

