/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.application;

import com.github.sidhant92.boolparser.constant.ContainerDataType;
import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.constant.Operator;
import com.github.sidhant92.boolparser.domain.BooleanNode;
import com.github.sidhant92.boolparser.domain.ComparisonNode;
import com.github.sidhant92.boolparser.domain.InNode;
import com.github.sidhant92.boolparser.domain.Node;
import com.github.sidhant92.boolparser.domain.NumericRangeNode;
import com.github.sidhant92.boolparser.domain.UnaryNode;
import com.github.sidhant92.boolparser.exception.DataNotFoundException;
import com.github.sidhant92.boolparser.exception.InvalidUnaryOperand;
import com.github.sidhant92.boolparser.operator.OperatorService;
import com.github.sidhant92.boolparser.parser.BoolExpressionParser;
import com.github.sidhant92.boolparser.util.ValueUtils;
import io.vavr.control.Try;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BooleanExpressionEvaluator {
    private static final Logger log = LoggerFactory.getLogger(BooleanExpressionEvaluator.class);
    private final BoolExpressionParser boolExpressionParser;
    private final OperatorService operatorService;

    public BooleanExpressionEvaluator(BoolExpressionParser boolExpressionParser) {
        this.boolExpressionParser = boolExpressionParser;
        this.operatorService = new OperatorService();
    }

    public Try<Boolean> evaluate(String expression, Map<String, Object> data) {
        Try<Node> tokenOptional = this.boolExpressionParser.parseExpression(expression);
        return tokenOptional.map(node -> this.evaluateToken((Node)node, data));
    }

    private boolean evaluateToken(Node node, Map<String, Object> data) {
        switch (node.getTokenType()) {
            case COMPARISON: {
                return this.evaluateComparisonToken((ComparisonNode)node, data);
            }
            case NUMERIC_RANGE: {
                return this.evaluateNumericRangeToken((NumericRangeNode)node, data);
            }
            case IN: {
                return this.evaluateInToken((InNode)node, data);
            }
            case UNARY: {
                return this.evaluateUnaryToken((UnaryNode)node, data);
            }
            case BOOLEAN: {
                return this.evaluateBooleanNode((BooleanNode)node, data);
            }
        }
        return false;
    }

    private boolean evaluateComparisonToken(ComparisonNode comparisonToken, Map<String, Object> data) {
        Object fieldData = ValueUtils.getValueFromMap(comparisonToken.getField(), data).orElseThrow(DataNotFoundException::new);
        return this.operatorService.evaluate(comparisonToken.getOperator(), ContainerDataType.primitive, comparisonToken.getDataType(), fieldData, comparisonToken.getValue());
    }

    private boolean evaluateNumericRangeToken(NumericRangeNode numericRangeToken, Map<String, Object> data) {
        Object fieldData = ValueUtils.getValueFromMap(numericRangeToken.getField(), data).orElseThrow(DataNotFoundException::new);
        return this.operatorService.evaluate(Operator.GREATER_THAN_EQUAL, ContainerDataType.primitive, numericRangeToken.getFromDataType(), fieldData, numericRangeToken.getFromValue()) && this.operatorService.evaluate(Operator.LESS_THAN_EQUAL, ContainerDataType.primitive, numericRangeToken.getToDataType(), fieldData, numericRangeToken.getToValue());
    }

    private boolean evaluateInToken(InNode inToken, Map<String, Object> data) {
        Object fieldData = ValueUtils.getValueFromMap(inToken.getField(), data).orElseThrow(DataNotFoundException::new);
        DataType dataType = (DataType)((Object)inToken.getItems().get(0).getLeft());
        Object[] values = inToken.getItems().stream().map(Pair::getRight).toArray();
        return this.operatorService.evaluate(Operator.IN, ContainerDataType.primitive, dataType, fieldData, values);
    }

    private boolean evaluateUnaryToken(UnaryNode unaryToken, Map<String, Object> data) {
        if (unaryToken.getDataType().equals((Object)DataType.BOOLEAN)) {
            return (Boolean)unaryToken.getValue();
        }
        Object fieldData = ValueUtils.getValueFromMap(unaryToken.getValue().toString(), data).orElseThrow(DataNotFoundException::new);
        if (!(fieldData instanceof Boolean)) {
            throw new InvalidUnaryOperand();
        }
        return (Boolean)fieldData;
    }

    private boolean evaluateBooleanNode(BooleanNode booleanToken, Map<String, Object> data) {
        switch (booleanToken.getOperator()) {
            case AND: {
                return this.evaluateToken(booleanToken.getLeft(), data) && this.evaluateToken(booleanToken.getRight(), data);
            }
            case OR: {
                return this.evaluateToken(booleanToken.getLeft(), data) || this.evaluateToken(booleanToken.getRight(), data);
            }
        }
        return !this.evaluateToken(booleanToken.getLeft(), data);
    }
}

