/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.constant;

import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.datatype.DataTypeFactory;
import com.github.sidhant92.boolparser.exception.InvalidDataType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public enum ContainerDataType {
    PRIMITIVE{

        @Override
        public <T> Optional<T> getValue(DataType dataType, Object value) {
            Optional result = DataTypeFactory.getDataType(dataType).getValue(value);
            if (!result.isPresent()) {
                throw new InvalidDataType(String.format("Invalid data type for value %s for data type %s", value, dataType.name()));
            }
            return result;
        }

        @Override
        public boolean isValid(DataType dataType, Object value) {
            return DataTypeFactory.getDataType(dataType).isValid(value);
        }
    }
    ,
    LIST{

        public Optional<List<?>> getValue(DataType dataType, Object value) {
            if (Objects.isNull(value) || !(value instanceof Collection) && !(value instanceof Object[])) {
                return Optional.empty();
            }
            if (value instanceof Object[]) {
                return Optional.of(Stream.of((Object[])value).map(v -> DataTypeFactory.getDataType(dataType).getValue(v)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
            }
            return Optional.of(((Collection)value).stream().map(v -> DataTypeFactory.getDataType(dataType).getValue(v)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
        }

        @Override
        public boolean isValid(DataType dataType, Object value) {
            if (Objects.isNull(value) || !(value instanceof Collection) && !(value instanceof Object[])) {
                return false;
            }
            if (value instanceof Object[]) {
                return Stream.of((Object[])value).allMatch(v -> DataTypeFactory.getDataType(dataType).isValid(v));
            }
            return ((Collection)value).stream().allMatch(v -> DataTypeFactory.getDataType(dataType).isValid(v));
        }
    };


    public abstract <T> Optional<T> getValue(DataType var1, Object var2);

    public abstract boolean isValid(DataType var1, Object var2);

    @Generated
    private ContainerDataType() {
    }
}

