/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.datatype;

import com.github.sidhant92.boolparser.constant.DataType;
import java.util.Optional;

public abstract class AbstractDataType<T extends Comparable<? super T>> {
    private final Class<T> clazz;

    public AbstractDataType(Class<T> clazz) {
        this.clazz = clazz;
    }

    protected boolean defaultIsValid(Object value) {
        return this.defaultIsValid(value, false);
    }

    protected boolean defaultIsValid(Object value, boolean useStrictValidation) {
        return this.clazz.isInstance(value);
    }

    protected Optional<T> defaultGetValue(Object value) {
        if (this.clazz.isInstance(value)) {
            return Optional.of((Comparable)this.clazz.cast(value));
        }
        return Optional.empty();
    }

    public abstract DataType getDataType();

    public abstract boolean isValid(Object var1);

    public abstract boolean isValid(Object var1, boolean var2);

    public abstract Optional<T> getValue(Object var1);
}

