/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.datatype;

import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.datatype.AbstractDataType;
import java.util.Optional;

public class BooleanDataType
extends AbstractDataType<Boolean> {
    public BooleanDataType() {
        super(Boolean.class);
    }

    @Override
    public DataType getDataType() {
        return DataType.BOOLEAN;
    }

    @Override
    public boolean isValid(Object value) {
        boolean isValid = super.defaultIsValid(value);
        if (!isValid) {
            String lowercase = value.toString().toLowerCase();
            return lowercase.equals("true") || lowercase.equals("false");
        }
        return true;
    }

    @Override
    public boolean isValid(Object value, boolean useStrictValidation) {
        if (!useStrictValidation) {
            return this.isValid(value);
        }
        return super.defaultIsValid(value);
    }

    @Override
    public Optional<Boolean> getValue(Object value) {
        Optional<Boolean> result = this.defaultGetValue(value);
        if (result.isPresent()) {
            return result;
        }
        if (this.isValid(value)) {
            return Optional.of(Boolean.parseBoolean(value.toString()));
        }
        return Optional.empty();
    }
}

