/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.datatype;

import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.datatype.AbstractDataType;
import java.math.BigDecimal;
import java.util.Optional;

public class IntegerDataType
extends AbstractDataType<Integer> {
    public IntegerDataType() {
        super(Integer.class);
    }

    @Override
    public DataType getDataType() {
        return DataType.INTEGER;
    }

    @Override
    public boolean isValid(Object value) {
        boolean isValid = super.defaultIsValid(value);
        if (!isValid) {
            try {
                BigDecimal number = new BigDecimal(value.toString());
                Integer.parseInt(number.stripTrailingZeros().toPlainString());
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isValid(Object value, boolean useStrictValidation) {
        if (!useStrictValidation) {
            return this.isValid(value);
        }
        return super.defaultIsValid(value);
    }

    @Override
    public Optional<Integer> getValue(Object value) {
        Optional<Integer> result = this.defaultGetValue(value);
        if (result.isPresent()) {
            return result;
        }
        try {
            BigDecimal number = new BigDecimal(value.toString());
            return Optional.of(Integer.parseInt(number.stripTrailingZeros().toPlainString()));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }
}

