/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.datatype;

import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.datatype.AbstractDataType;
import java.math.BigDecimal;
import java.util.Optional;

public class LongDataType
extends AbstractDataType<Long> {
    public LongDataType() {
        super(Long.class);
    }

    @Override
    public DataType getDataType() {
        return DataType.LONG;
    }

    @Override
    public boolean isValid(Object value) {
        boolean isValid = super.defaultIsValid(value);
        if (!isValid) {
            try {
                BigDecimal number = new BigDecimal(value.toString());
                Long.parseLong(number.stripTrailingZeros().toPlainString());
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isValid(Object value, boolean useStrictValidation) {
        if (!useStrictValidation) {
            return this.isValid(value);
        }
        return super.defaultIsValid(value);
    }

    @Override
    public Optional<Long> getValue(Object value) {
        Optional<Long> result = this.defaultGetValue(value);
        if (result.isPresent()) {
            return result;
        }
        try {
            BigDecimal number = new BigDecimal(value.toString());
            return Optional.of(Long.parseLong(number.stripTrailingZeros().toPlainString()));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }
}

