/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.domain.logical;

import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.constant.NodeType;
import com.github.sidhant92.boolparser.constant.Operator;
import com.github.sidhant92.boolparser.domain.FieldNode;
import com.github.sidhant92.boolparser.domain.logical.Node;
import lombok.Generated;

public class ComparisonNode
extends Node {
    private final Node left;
    private final Node right;
    private final Operator operator;
    private final DataType dataType;

    @Override
    public NodeType getTokenType() {
        return NodeType.COMPARISON;
    }

    public boolean isNullCheck() {
        return Operator.getEqualityOperators().contains((Object)this.operator) && (this.right instanceof FieldNode && ((FieldNode)this.right).isNull() || this.left instanceof FieldNode && ((FieldNode)this.left).isNull());
    }

    @Generated
    public static ComparisonNodeBuilder builder() {
        return new ComparisonNodeBuilder();
    }

    @Generated
    public ComparisonNode(Node left, Node right, Operator operator, DataType dataType) {
        this.left = left;
        this.right = right;
        this.operator = operator;
        this.dataType = dataType;
    }

    @Generated
    public Node getLeft() {
        return this.left;
    }

    @Generated
    public Node getRight() {
        return this.right;
    }

    @Generated
    public Operator getOperator() {
        return this.operator;
    }

    @Generated
    public DataType getDataType() {
        return this.dataType;
    }

    @Generated
    public static class ComparisonNodeBuilder {
        @Generated
        private Node left;
        @Generated
        private Node right;
        @Generated
        private Operator operator;
        @Generated
        private DataType dataType;

        @Generated
        ComparisonNodeBuilder() {
        }

        @Generated
        public ComparisonNodeBuilder left(Node left) {
            this.left = left;
            return this;
        }

        @Generated
        public ComparisonNodeBuilder right(Node right) {
            this.right = right;
            return this;
        }

        @Generated
        public ComparisonNodeBuilder operator(Operator operator) {
            this.operator = operator;
            return this;
        }

        @Generated
        public ComparisonNodeBuilder dataType(DataType dataType) {
            this.dataType = dataType;
            return this;
        }

        @Generated
        public ComparisonNode build() {
            return new ComparisonNode(this.left, this.right, this.operator, this.dataType);
        }

        @Generated
        public String toString() {
            return "ComparisonNode.ComparisonNodeBuilder(left=" + String.valueOf(this.left) + ", right=" + String.valueOf(this.right) + ", operator=" + String.valueOf((Object)this.operator) + ", dataType=" + String.valueOf((Object)this.dataType) + ")";
        }
    }
}

