/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.function.arithmetic;

import com.github.sidhant92.boolparser.constant.ContainerDataType;
import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.constant.FunctionType;
import com.github.sidhant92.boolparser.datatype.DataTypeFactory;
import com.github.sidhant92.boolparser.domain.EvaluatedNode;
import com.github.sidhant92.boolparser.function.arithmetic.AbstractFunction;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class IntFunction
extends AbstractFunction {
    @Override
    public Object evaluate(List<EvaluatedNode> items) {
        EvaluatedNode item = items.get(0);
        if (item.getDataType() == DataType.DECIMAL) {
            return ((BigDecimal)DataTypeFactory.getDataType(DataType.DECIMAL).getValue(item.getValue()).get()).intValue();
        }
        if (item.getDataType() == DataType.LONG) {
            return ((Long)item.getValue()).intValue();
        }
        return item.getValue();
    }

    @Override
    public FunctionType getFunctionType() {
        return FunctionType.INT;
    }

    @Override
    public List<ContainerDataType> getAllowedContainerTypes() {
        return Collections.singletonList(ContainerDataType.PRIMITIVE);
    }

    @Override
    public List<DataType> getAllowedDataTypes() {
        return Arrays.asList(DataType.INTEGER, DataType.LONG, DataType.DECIMAL);
    }
}

